import React from "react";
import { Helmet } from "react-helmet";
const ResourcesContainer = ({ resources }) => {
    const scriptTags = [];
    const styleTags = [];
    if (resources) {
        for (const key in resources.styles) {
            styleTags.push(React.createElement("link", { rel: "stylesheet", href: resources.styles[key], key: key }));
        }
        for (const key in resources.scripts) {
            scriptTags.push(React.createElement("script", { src: resources.scripts[key], type: "text/javascript", async: false, key: key }));
        }
    }
    return (React.createElement(Helmet, null,
        styleTags,
        scriptTags));
};
export default ResourcesContainer;
//# sourceMappingURL=ResourcesContainer.js.map