import React, { useCallback } from "react";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
export const EmbeddedFormDisplayer = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({
        startSubmit: (context) => {
            return envelopeServer.envelopeApi.requests.formDisplayer__startSubmit(context);
        },
        notifySubmitResult: (response) => {
            envelopeServer.envelopeApi.notifications.formDisplayer__notifySubmitResponse.send(response);
        },
        init: (args) => {
            envelopeServer.envelopeApi.notifications.formDisplayer__notifyInit.send(args);
        },
    }), []);
    const pollInit = useCallback((envelopeServer) => {
        var _a, _b;
        return envelopeServer.envelopeApi.requests.formDisplayer__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, {
            form: props.formContent,
            data: (_a = props.data) !== null && _a !== void 0 ? _a : {},
            context: (_b = props.context) !== null && _b !== void 0 ? _b : {},
        });
    }, []);
    return (React.createElement(EmbeddedFormDisplayerEnvelope, { ref: forwardedRef, apiImpl: {
            notifyOnOpenForm: (opened) => {
                if (props.onOpenForm) {
                    props.onOpenForm(opened);
                }
            },
        }, origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: {
            containerType: ContainerType.IFRAME,
            envelopePath: props.envelopePath,
        } }));
});
const EmbeddedFormDisplayerEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedFormDisplayer.js.map