import React, { useContext } from "react";
export class FormDetailsContextImpl {
    constructor() {
        this.updateContentListeners = [];
    }
    updateContent(formContent) {
        if (formContent) {
            this.updateContentListeners.forEach((listener) => listener.onUpdateContent(formContent));
        }
    }
    onUpdateContent(listener) {
        this.updateContentListeners.push(listener);
        return {
            unSubscribe: () => {
                const index = this.updateContentListeners.indexOf(listener);
                if (index > -1) {
                    this.updateContentListeners.splice(index, 1);
                }
            },
        };
    }
}
const RuntimeToolsFormDetailsContext = React.createContext({});
export default RuntimeToolsFormDetailsContext;
export const useFormDetailsContext = () => useContext(RuntimeToolsFormDetailsContext);
//# sourceMappingURL=FormDetailsContext.js.map