import React, { useMemo } from "react";
import { TextContent } from "@patternfly/react-core/dist/js/components/Text";
import ReactJson from "react-json-view";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
export default function WorkflowResult(props) {
    const filteredResponse = useMemo(() => ({ workflowdata: props.response.workflowdata }), [props.response]);
    return (React.createElement(React.Fragment, null,
        React.createElement(TextContent, null,
            React.createElement(Title, { headingLevel: "h3" }, "Workflow result")),
        React.createElement("br", null),
        React.createElement(TextContent, null,
            React.createElement("div", null,
                React.createElement(ReactJson, { src: filteredResponse, name: false })))));
}
//# sourceMappingURL=WorkflowResult.js.map