import React, { useCallback } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { init } from "../envelope";
import { WorkflowDetailsChannelApiImpl } from "./WorkflowDetailsChannelApiImpl";
export const EmbeddedWorkflowDetails = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback((envelopeServer, container) => {
        init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
        });
        return envelopeServer.envelopeApi.requests.workflowDetails__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, {
            workflowInstance: props.workflowInstance,
        });
    }, []);
    return (React.createElement(EmbeddedWorkflowDetailsEnvelope, { ref: forwardedRef, apiImpl: new WorkflowDetailsChannelApiImpl(props.driver), origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedWorkflowDetailsEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedWorkflowDetails.js.map