var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React from "react";
import { Modal, ModalVariant, ModalBoxBody } from "@patternfly/react-core/dist/js/components/Modal";
import { TextContent, Text } from "@patternfly/react-core/dist/js/components/Text";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { OutlinedClockIcon } from "@patternfly/react-icons/dist/js/icons/outlined-clock-icon";
import DateTimePicker from "react-datetime-picker";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
export const JobsRescheduleModal = ({ job, actionType, modalAction, isModalOpen, handleModalToggle, rescheduleError, setRescheduleError, handleJobReschedule, ouiaId, ouiaSafe, }) => {
    const [scheduleDate, setScheduleDate] = React.useState(new Date(job.expirationTime));
    const [repeatInterval, setRepeatInterval] = React.useState(job.repeatInterval);
    const [repeatLimit, setRepeatLimit] = React.useState(job.repeatLimit);
    const [errorModalOpen, setErrorModalOpen] = React.useState(false);
    const handleIntervalChange = (value) => {
        setRepeatInterval(value);
    };
    const handleLimitChange = (value) => {
        setRepeatLimit(value);
    };
    const handleDateChange = (value) => {
        setScheduleDate(value);
    };
    const handleTimeNow = () => {
        setScheduleDate(new Date());
    };
    const onApplyReschedule = () => __awaiter(void 0, void 0, void 0, function* () {
        yield handleJobReschedule(job, repeatInterval, repeatLimit, scheduleDate);
    });
    const applyAction = [
        React.createElement(Button, { key: "apply-selection", variant: "primary", id: "apply-button", onClick: onApplyReschedule }, "Apply"),
    ];
    const modalContent = () => {
        return (React.createElement(ModalBoxBody, { className: "kogito-management-console-shared--jobsModal__ModalBody" },
            React.createElement(Form, { isHorizontal: true },
                React.createElement(FormGroup, { label: "Expiration Time", fieldId: "horizontal-form-name" },
                    scheduleDate && scheduleDate !== undefined && (React.createElement(DateTimePicker, { value: scheduleDate, minDate: new Date(), onChange: handleDateChange })),
                    React.createElement(Button, { className: "kogito-management-console-shared--jobsModal__TimeNow", id: "Time-now", onClick: handleTimeNow },
                        React.createElement(OutlinedClockIcon, null),
                        " Now")),
                React.createElement(FormGroup, { label: "Repeat Interval", fieldId: "repeat-interval", helperText: repeatInterval === null ? "Input disabled since it is an one-time run job" : null },
                    React.createElement(TextInput, { type: "text", id: "repeat-interval-input", name: "repeat-interval-input", "aria-describedby": "repeat-interval", value: repeatInterval || "", onChange: handleIntervalChange, isDisabled: repeatInterval === null })),
                React.createElement(FormGroup, { label: "Repeat Limit", fieldId: "repeat-limit", helperText: repeatLimit === null ? "Input disabled since it is an one-time run job" : null },
                    React.createElement(TextInput, { type: "text", id: "repeat-limit-input", name: "repeat-limit-input", "aria-describedby": "repeat-limit", value: repeatLimit || "", onChange: handleLimitChange, isDisabled: repeatLimit === null })))));
    };
    const handleErrorModal = () => {
        setErrorModalOpen(!errorModalOpen);
    };
    const errorModalAction = [
        React.createElement(Button, { key: "confirm-selection", variant: "primary", onClick: () => {
                handleErrorModal();
                setRescheduleError("");
            } }, "OK"),
    ];
    React.useEffect(() => {
        rescheduleError.length > 0 && handleErrorModal();
    }, [rescheduleError]);
    const errorModalContent = () => {
        return (React.createElement(ModalBoxBody, null,
            React.createElement(TextContent, null,
                React.createElement(Text, null, rescheduleError))));
    };
    return (React.createElement(React.Fragment, null,
        React.createElement(Modal, Object.assign({ variant: ModalVariant.small, "aria-labelledby": "actionType" + " modal", "aria-label": actionType + " modal", title: "", header: setTitle("success", "Job Reschedule"), isOpen: isModalOpen, onClose: handleModalToggle, actions: [...applyAction, ...modalAction] }, componentOuiaProps(ouiaId, "job-reschedule-modal", ouiaSafe)), modalContent()),
        React.createElement(Modal, Object.assign({ variant: ModalVariant.small, "aria-labelledby": "Reschedule error modal", "aria-label": "Reschedule error modal", title: "", header: setTitle("failure", "Job Reschedule"), isOpen: errorModalOpen, onClose: handleErrorModal, actions: errorModalAction }, componentOuiaProps(ouiaId, "job-reschedule-error-modal", ouiaSafe)), errorModalContent())));
};
//# sourceMappingURL=JobsRescheduleModal.js.map