import isPlainObject from "lodash/isPlainObject";
class FormValidationsImpl {
    constructor(validations) {
        this.validations = validations;
    }
    getFieldValidation(fieldId) {
        return this.validations[fieldId];
    }
    isValid() {
        return Object.keys(this.validations).length == 0;
    }
}
export function validateCloudEventRequest(eventRequest) {
    const validations = {};
    if (!eventRequest.endpoint) {
        validations["endpoint"] = "The Cloud Event endpoint cannot be empty.";
    }
    if (!eventRequest.headers.type) {
        validations["eventType"] = "The Cloud Event type cannot be empty.";
    }
    if (eventRequest.data) {
        try {
            const json = JSON.parse(eventRequest.data);
            if (!isPlainObject(json)) {
                throw new Error("not an object");
            }
        }
        catch (err) {
            validations["eventData"] = "The Cloud Event data should have a JSON format.";
        }
    }
    return new FormValidationsImpl(validations);
}
//# sourceMappingURL=validateCloudEventRequest.js.map