var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { DocumentationLinksFormGroup } from "./DocumentationLinksFormGroup";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { renameDrgElement } from "../mutations/renameNode";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { useCallback } from "react";
export function KnowledgeSourceProperties(_a) {
    var _b, _c, _d;
    var knowledgeSource = _a.knowledgeSource, namespace = _a.namespace, index = _a.index;
    var setState = useDmnEditorStoreApi().setState;
    var thisDmnsNamespace = useDmnEditorStore(function (s) { return s.dmn.model.definitions["@_namespace"]; });
    var isReadonly = !!namespace && namespace !== thisDmnsNamespace;
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, __assign({ label: "Name" }, { children: _jsx(InlineFeelNameInput, { enableAutoFocusing: false, isPlain: false, id: knowledgeSource["@_id"], name: knowledgeSource["@_name"], isReadonly: isReadonly, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: function (newName) {
                        setState(function (state) {
                            renameDrgElement({
                                definitions: state.dmn.model.definitions,
                                index: index,
                                newName: newName,
                            });
                        });
                    }, allUniqueNames: useCallback(function (s) { return s.computed(s).getAllFeelVariableUniqueNames(); }, []) }) })), _jsx(FormGroup, __assign({ label: "Description" }, { children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: isReadonly, value: (_b = knowledgeSource.description) === null || _b === void 0 ? void 0 : _b.__$$text, onChange: function (newDescription) {
                        setState(function (state) {
                            state.dmn.model.definitions.drgElement[index].description = {
                                __$$text: newDescription,
                            };
                        });
                    }, placeholder: "Enter a description...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }) })), _jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ isReadOnly: true, hoverTip: "Copy", clickTip: "Copied" }, { children: knowledgeSource["@_id"] })) })), _jsx(FormGroup, __assign({ label: "Source type" }, { children: _jsx(TextInput, { "aria-label": "Source type", type: "text", isDisabled: isReadonly, value: (_c = knowledgeSource.type) === null || _c === void 0 ? void 0 : _c.__$$text, onChange: function (newType) {
                        setState(function (state) {
                            state.dmn.model.definitions.drgElement[index].type = {
                                __$$text: newType,
                            };
                        });
                    }, placeholder: "Enter source type..." }) })), _jsx(FormGroup, __assign({ label: "Location URI" }, { children: _jsx(TextInput, { "aria-label": "Location URI", type: "text", isDisabled: isReadonly, value: knowledgeSource["@_locationURI"], onChange: function (newLocationUri) {
                        setState(function (state) {
                            state.dmn.model.definitions.drgElement[index]["@_locationURI"] =
                                newLocationUri;
                        });
                    }, placeholder: "Enter location URI..." }) })), _jsx(DocumentationLinksFormGroup, { isReadonly: isReadonly, values: (_d = knowledgeSource.extensionElements) === null || _d === void 0 ? void 0 : _d["kie:attachment"], onChange: function (newExtensionElements) {
                    setState(function (state) {
                        state.dmn.model.definitions.drgElement[index].extensionElements =
                            {
                                "kie:attachment": newExtensionElements,
                            };
                    });
                } })] }));
}
//# sourceMappingURL=KnowledgeSourceProperties.js.map