import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo } from "react";
import { TextField, TextFieldType } from "./Fields";
import { useDmnEditorStore } from "../../store/StoreContext";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
export function IteratorVariableCell(props) {
    var _a, _b, _c;
    var selectedObjectId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.selectedObjectId; });
    var selectedObjectInfos = useMemo(function () { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    var updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    var cell = useMemo(function () { return selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell; }, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    return (_jsx(_Fragment, { children: _jsx(TextField, { type: TextFieldType.TEXT_INPUT, title: "Variable to interate over", placeholder: "Enter the variable name...", isReadonly: props.isReadonly, initialValue: (_b = cell["@_iteratorVariable"]) !== null && _b !== void 0 ? _b : "", expressionPath: (_c = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _c !== void 0 ? _c : [], onChange: function (newVariable) {
                return updater(function (dmnObject) {
                    dmnObject["@_iteratorVariable"] = newVariable;
                });
            } }) }));
}
//# sourceMappingURL=IteratorVariableCell.js.map