import * as React from "react";
import { ExpressionPath } from "../../boxedExpressions/boxedExpressionIndex";
import { UniqueNameIndex } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { State } from "../../store/Store";
export declare function ContentField(props: {
    initialValue: string;
    onChange: (newTextValue: string, expressionPath: ExpressionPath[]) => void;
    expressionPath: ExpressionPath[];
    isReadonly: boolean;
}): JSX.Element;
export declare function DescriptionField(props: {
    initialValue: string;
    onChange: (newTextValue: string, expressionPath: ExpressionPath[]) => void;
    expressionPath: ExpressionPath[];
    isReadonly: boolean;
}): JSX.Element;
export declare function ExpressionLanguageField(props: {
    initialValue: string;
    onChange?: (newTextValue: string, expressionPath?: ExpressionPath[]) => void;
    expressionPath?: ExpressionPath[];
    isReadonly: boolean;
}): JSX.Element;
export declare function NameField(props: {
    alternativeFieldName?: string;
    id: string;
    name: string;
    isReadonly: boolean;
    getAllUniqueNames: (s: State) => UniqueNameIndex;
    onChange?: (newName: string) => void;
}): JSX.Element;
export declare function TypeRefField(props: {
    alternativeFieldName?: string;
    typeRef?: string;
    isReadonly: boolean;
    dmnEditorRootElementRef: React.RefObject<HTMLElement>;
    onChange?: (newTypeRef: string) => void;
}): JSX.Element;
export declare enum TextFieldType {
    TEXT_AREA = "text-area",
    TEXT_INPUT = "text-input"
}
export declare function TextField({ onChange, ...props }: {
    initialValue: string;
    onChange?: (newTextValue: string, expressionPath?: ExpressionPath[]) => void;
    expressionPath?: ExpressionPath[];
    isReadonly: boolean;
    title: string;
    placeholder?: string;
    type: TextFieldType;
}): JSX.Element;
//# sourceMappingURL=Fields.d.ts.map