import { addOrGetDrd } from "./addOrGetDrd";
import { snapShapeDimensions, snapShapePosition } from "../diagram/SnapGrid";
import { MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { addNamespaceToHref } from "../xml/xmlHrefs";
export var DECISION_SERVICE_DIVIDER_LINE_PADDING = 100;
export function updateDecisionServiceDividerLine(_a) {
    var _b, _c, _d;
    var definitions = _a.definitions, drdIndex = _a.drdIndex, __readonly_dmnShapesByHref = _a.__readonly_dmnShapesByHref, __readonly_dmnObjectNamespace = _a.__readonly_dmnObjectNamespace, __readonly_externalDmnsIndex = _a.__readonly_externalDmnsIndex, shapeIndex = _a.shapeIndex, localYPosition = _a.localYPosition, drgElementIndex = _a.drgElementIndex, snapGrid = _a.snapGrid;
    var diagramElements = addOrGetDrd({ definitions: definitions, drdIndex: drdIndex }).diagramElements;
    var shape = diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements[shapeIndex];
    var shapeBounds = shape === null || shape === void 0 ? void 0 : shape["dc:Bounds"];
    if (!shapeBounds) {
        throw new Error("DMN MUTATION: Cannot reposition divider line of non-existent shape bounds");
    }
    var externalDmn = __readonly_externalDmnsIndex.get(__readonly_dmnObjectNamespace !== null && __readonly_dmnObjectNamespace !== void 0 ? __readonly_dmnObjectNamespace : "");
    var ds = externalDmn === undefined
        ? definitions.drgElement[drgElementIndex]
        : externalDmn.model.definitions.drgElement[drgElementIndex];
    if (!ds) {
        throw new Error("DMN MUTATION: Cannot reposition divider line of non-existent Decision Service");
    }
    var decisionMinSizes = MIN_NODE_SIZES[NODE_TYPES.decision]({ snapGrid: snapGrid });
    var decisionServiceMinSizes = MIN_NODE_SIZES[NODE_TYPES.decisionService]({ snapGrid: snapGrid });
    var snappedPosition = snapShapePosition(snapGrid, shape);
    var snappedDimensions = snapShapeDimensions(snapGrid, shape, decisionServiceMinSizes);
    var upperLimit = ((_b = ds.outputDecision) !== null && _b !== void 0 ? _b : []).reduce(function (acc, od) {
        var href = __readonly_dmnObjectNamespace !== undefined
            ? addNamespaceToHref({
                href: od["@_href"],
                namespace: definitions["@_namespace"] === __readonly_dmnObjectNamespace ? undefined : __readonly_dmnObjectNamespace,
            })
            : od["@_href"];
        var v = snapShapePosition(snapGrid, __readonly_dmnShapesByHref.get(href)).y +
            snapShapeDimensions(snapGrid, __readonly_dmnShapesByHref.get(href), decisionMinSizes).height;
        return v > acc ? v : acc;
    }, snappedPosition.y + DECISION_SERVICE_DIVIDER_LINE_PADDING);
    var lowerLimit = ((_c = ds.encapsulatedDecision) !== null && _c !== void 0 ? _c : []).reduce(function (acc, ed) {
        var href = __readonly_dmnObjectNamespace !== undefined
            ? addNamespaceToHref({
                href: ed["@_href"],
                namespace: definitions["@_namespace"] === __readonly_dmnObjectNamespace
                    ? undefined
                    : __readonly_dmnObjectNamespace,
            })
            : ed["@_href"];
        var v = snapShapePosition(snapGrid, __readonly_dmnShapesByHref.get(href)).y;
        return v < acc ? v : acc;
    }, snappedPosition.y + snappedDimensions.height - DECISION_SERVICE_DIVIDER_LINE_PADDING);
    var newDividerLineYPosition = Math.max(upperLimit, Math.min(snappedPosition.y + localYPosition, lowerLimit));
    (_d = shape["dmndi:DMNDecisionServiceDividerLine"]) !== null && _d !== void 0 ? _d : (shape["dmndi:DMNDecisionServiceDividerLine"] = getCentralizedDecisionServiceDividerLine(shapeBounds));
    shape["dmndi:DMNDecisionServiceDividerLine"]["di:waypoint"][0]["@_y"] = newDividerLineYPosition;
    shape["dmndi:DMNDecisionServiceDividerLine"]["di:waypoint"][1]["@_y"] = newDividerLineYPosition;
}
export function getCentralizedDecisionServiceDividerLine(bounds) {
    return {
        "@_id": generateUuid(),
        "di:waypoint": [
            { "@_x": bounds["@_x"], "@_y": bounds["@_y"] + bounds["@_height"] / 2 },
            {
                "@_x": bounds["@_x"] + bounds["@_height"],
                "@_y": bounds["@_y"] + bounds["@_height"] / 2,
            },
        ],
    };
}
//# sourceMappingURL=updateDecisionServiceDividerLine.js.map