var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var _a;
import { NODE_TYPES } from "../nodes/NodeTypes";
import { EDGE_TYPES } from "../edges/EdgeTypes";
export var graphStructure = new Map([
    [
        NODE_TYPES.inputData,
        new Map([
            [EDGE_TYPES.informationRequirement, new Set([NODE_TYPES.decision])],
            [EDGE_TYPES.authorityRequirement, new Set([NODE_TYPES.knowledgeSource])],
            [EDGE_TYPES.association, new Set([NODE_TYPES.textAnnotation])],
        ]),
    ],
    [
        NODE_TYPES.decision,
        new Map([
            [EDGE_TYPES.informationRequirement, new Set([NODE_TYPES.decision])],
            [EDGE_TYPES.authorityRequirement, new Set([NODE_TYPES.knowledgeSource])],
            [EDGE_TYPES.association, new Set([NODE_TYPES.textAnnotation])],
        ]),
    ],
    [
        NODE_TYPES.bkm,
        new Map([
            [EDGE_TYPES.knowledgeRequirement, new Set([NODE_TYPES.decision, NODE_TYPES.bkm])],
            [EDGE_TYPES.association, new Set([NODE_TYPES.textAnnotation])],
        ]),
    ],
    [
        NODE_TYPES.decisionService,
        new Map([
            [EDGE_TYPES.knowledgeRequirement, new Set([NODE_TYPES.decision, NODE_TYPES.bkm])],
            [EDGE_TYPES.association, new Set([NODE_TYPES.textAnnotation])],
        ]),
    ],
    [
        NODE_TYPES.knowledgeSource,
        new Map([
            [EDGE_TYPES.authorityRequirement, new Set([NODE_TYPES.decision, NODE_TYPES.bkm, NODE_TYPES.knowledgeSource])],
        ]),
    ],
    [
        NODE_TYPES.textAnnotation,
        new Map([
            [
                EDGE_TYPES.association,
                new Set([
                    NODE_TYPES.inputData,
                    NODE_TYPES.decision,
                    NODE_TYPES.bkm,
                    NODE_TYPES.decisionService,
                    NODE_TYPES.knowledgeSource,
                ]),
            ],
        ]),
    ],
    [
        NODE_TYPES.group,
        new Map([
            [EDGE_TYPES.association, new Set([NODE_TYPES.textAnnotation])],
        ]),
    ],
]);
export var outgoingStructure = (_a = {},
    _a[NODE_TYPES.inputData] = {
        nodes: outgoingNodes(NODE_TYPES.inputData),
        edges: outgoingEdges(NODE_TYPES.inputData),
    },
    _a[NODE_TYPES.decision] = {
        nodes: outgoingNodes(NODE_TYPES.decision),
        edges: outgoingEdges(NODE_TYPES.decision),
    },
    _a[NODE_TYPES.bkm] = {
        nodes: outgoingNodes(NODE_TYPES.bkm),
        edges: outgoingEdges(NODE_TYPES.bkm),
    },
    _a[NODE_TYPES.decisionService] = {
        nodes: outgoingNodes(NODE_TYPES.decisionService),
        edges: outgoingEdges(NODE_TYPES.decisionService),
    },
    _a[NODE_TYPES.knowledgeSource] = {
        nodes: outgoingNodes(NODE_TYPES.knowledgeSource),
        edges: outgoingEdges(NODE_TYPES.knowledgeSource),
    },
    _a[NODE_TYPES.group] = {
        nodes: outgoingNodes(NODE_TYPES.group),
        edges: outgoingEdges(NODE_TYPES.group),
    },
    _a[NODE_TYPES.textAnnotation] = {
        nodes: [],
        edges: outgoingEdges(NODE_TYPES.textAnnotation),
    },
    _a);
export var containment = new Map([
    [NODE_TYPES.decisionService, new Set([NODE_TYPES.decision])],
]);
function outgoingNodes(srcNodeType) {
    var _a;
    return Array.from(((_a = graphStructure.get(srcNodeType)) !== null && _a !== void 0 ? _a : new Map()).values()).flatMap(function (tgt) { return __spreadArray([], __read(tgt), false); });
}
function outgoingEdges(srcNodeType) {
    var _a;
    return Array.from(((_a = graphStructure.get(srcNodeType)) !== null && _a !== void 0 ? _a : new Map()).keys());
}
export function getDefaultEdgeTypeBetween(source, target) {
    var edges = getEdgeTypesBetween(source, target);
    if (edges.length > 1) {
        console.debug("Multiple edges possible for ".concat(source, " --> ").concat(target, ". Choosing first one in structure definition: ").concat(edges[0], "."));
    }
    return edges[0];
}
export function getEdgeTypesBetween(source, target) {
    var e_1, _a;
    var sourceStructure = graphStructure.get(source);
    if (!sourceStructure) {
        return [];
    }
    var possibleEdges = [];
    try {
        for (var _b = __values(__spreadArray([], __read(sourceStructure.entries()), false)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var _d = __read(_c.value, 2), e = _d[0], t = _d[1];
            if (t.has(target)) {
                possibleEdges.push(e);
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return possibleEdges;
}
//# sourceMappingURL=graphStructure.js.map