"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SwfStunnerEditor = void 0;
var SwfStunnerEditor = (function () {
    function SwfStunnerEditor(envelopeApi) {
        this.session = {
            getAllNodesUUID: function () {
                return envelopeApi.requests.editor_session_getAllNodesUUID();
            },
            getEdgeByUUID: function (uuid) {
                return envelopeApi.requests.editor_session_getEdgeByUUID(uuid);
            },
            getNodeByUUID: function (uuid) {
                return envelopeApi.requests.editor_session_getNodeByUUID(uuid);
            },
            getDefinitionByElementUUID: function (uuid) {
                return envelopeApi.requests.editor_session_getDefinitionByElementUUID(uuid);
            },
            getNodeByName: function (name) {
                return envelopeApi.requests.editor_session_getNodeByName(name);
            },
            getNodeName: function (node) {
                return envelopeApi.requests.editor_session_getNodeName(node);
            },
            getSelectedElementUUID: function () {
                return envelopeApi.requests.editor_session_getSelectedElementUUID();
            },
            getSelectedNode: function () {
                return envelopeApi.requests.editor_session_getSelectedNode();
            },
            getSelectedEdge: function () {
                return envelopeApi.requests.editor_session_getSelectedEdge();
            },
            getSelectedDefinition: function () {
                return envelopeApi.requests.editor_session_getSelectedDefinition();
            },
            selectByUUID: function (uuid) {
                envelopeApi.requests.editor_session_selectByUUID(uuid);
                return Promise.resolve();
            },
            selectByName: function (name) {
                envelopeApi.requests.editor_session_selectByName(name);
                return Promise.resolve();
            },
            clearSelection: function () {
                envelopeApi.requests.editor_session_clearSelection();
                return Promise.resolve();
            },
        };
        this.canvas = {
            getShapeIds: function () {
                return envelopeApi.requests.editor_canvas_getShapeIds();
            },
            getBackgroundColor: function (uuid) {
                return envelopeApi.requests.editor_canvas_getBackgroundColor(uuid);
            },
            setBackgroundColor: function (uuid, color) {
                envelopeApi.requests.editor_canvas_setBackgroundColor(uuid, color);
                return Promise.resolve();
            },
            getBorderColor: function (uuid) {
                return envelopeApi.requests.editor_canvas_getBorderColor(uuid);
            },
            setBorderColor: function (uuid, color) {
                envelopeApi.requests.editor_canvas_setBorderColor(uuid, color);
                return Promise.resolve();
            },
            getLocation: function (uuid) {
                return envelopeApi.requests.editor_canvas_getLocation(uuid);
            },
            getAbsoluteLocation: function (uuid) {
                return envelopeApi.requests.editor_canvas_getAbsoluteLocation(uuid);
            },
            getDimensions: function (uuid) {
                return envelopeApi.requests.editor_canvas_getDimensions(uuid);
            },
            center: function (uuid) {
                envelopeApi.requests.editor_canvas_center(uuid);
                return Promise.resolve();
            },
            draw: function () {
                envelopeApi.requests.editor_canvas_draw();
                return Promise.resolve();
            },
        };
    }
    return SwfStunnerEditor;
}());
exports.SwfStunnerEditor = SwfStunnerEditor;
//# sourceMappingURL=ServerlessWorkflowStunnerEditor.js.map