import { Node, Edge } from "./StunnerEditorEnvelopeAPI";
export interface SwfStunnerEditorAPI {
    session: SwfStunnerEditoSession;
    canvas: SwfStunnerEditorCanvas;
}
export interface SwfStunnerEditoSession {
    getAllNodesUUID(): Promise<string[]>;
    getEdgeByUUID(uuid: string): Promise<Edge>;
    getNodeByUUID(uuid: string): Promise<Node>;
    getDefinitionByElementUUID(uuid: string): Promise<Object>;
    getNodeByName(name: string): Promise<Node>;
    getNodeName(node: Node): Promise<string>;
    getSelectedElementUUID(): Promise<string>;
    getSelectedNode(): Promise<Node>;
    getSelectedEdge(): Promise<Edge>;
    getSelectedDefinition(): Promise<Object>;
    selectByUUID(uuid: string): Promise<void>;
    selectByName(name: string): Promise<void>;
    clearSelection(): Promise<void>;
}
export interface SwfStunnerEditorCanvas {
    getShapeIds(): Promise<string[]>;
    getBackgroundColor(uuid: string): Promise<string>;
    setBackgroundColor(uuid: string, backgroundColor: string): Promise<void>;
    getBorderColor(uuid: string): Promise<string>;
    setBorderColor(uuid: string, borderColor: string): Promise<void>;
    getLocation(uuid: string): Promise<number[]>;
    getAbsoluteLocation(uuid: string): Promise<number[]>;
    getDimensions(uuid: string): Promise<number[]>;
    center(uuid: string): Promise<void>;
    draw(): Promise<void>;
}
//# sourceMappingURL=SwfStunnerEditorAPI.d.ts.map