"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.switchExpression = void 0;
var switchExpression = function (switchValue, cases) {
    var e_1, _a;
    var hasDefault = Object.hasOwn(cases, "default");
    if (!switchValue) {
        if (hasDefault) {
            return cases.default;
        }
        throw new Error("No value provided to switchExpression and no default exists.");
    }
    var propertyValue;
    var didMatch = false;
    try {
        for (var _b = __values(Object.entries(cases)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var _d = __read(_c.value, 2), key = _d[0], value = _d[1];
            if (key === switchValue) {
                propertyValue = value;
                didMatch = true;
                break;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    if (didMatch) {
        return propertyValue;
    }
    if (hasDefault) {
        return cases.default;
    }
    throw new Error("Non matched key and no default exists for switchExpression.");
};
exports.switchExpression = switchExpression;
//# sourceMappingURL=switchExpression.js.map