"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TokenTree = void 0;
var Node_1 = require("./Node");
var TokenTree = (function () {
    function TokenTree() {
        this.root = new Node_1.Node();
    }
    TokenTree.prototype.addName = function (tokens) {
        var e_1, _a;
        var current = this.root;
        try {
            for (var tokens_1 = __values(tokens), tokens_1_1 = tokens_1.next(); !tokens_1_1.done; tokens_1_1 = tokens_1.next()) {
                var token = tokens_1_1.value;
                var next = this.findToken(current, token);
                if (!next) {
                    next = new Node_1.Node(token, current);
                    current.children.push(next);
                }
                current = next;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (tokens_1_1 && !tokens_1_1.done && (_a = tokens_1.return)) _a.call(tokens_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    TokenTree.prototype.findToken = function (current, t) {
        var e_2, _a;
        try {
            for (var _b = __values(current.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var n = _c.value;
                if (n.token === t) {
                    return n;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return undefined;
    };
    TokenTree.prototype.start = function (t) {
        this.currentNode = this.findToken(this.root, t);
    };
    TokenTree.prototype.followUp = function (t, commit) {
        if (this.currentNode == null) {
            return false;
        }
        var node = this.findToken(this.currentNode, t);
        if (commit) {
            this.currentNode = node;
        }
        return node != null;
    };
    return TokenTree;
}());
exports.TokenTree = TokenTree;
//# sourceMappingURL=TokenTree.js.map