import * as React from "react";
import { useEffect, useState } from "react";
export const NestedExpressionContainerContext = React.createContext({
    minWidth: -2,
    actualWidth: -2,
    resizingWidth: {
        value: -2,
        isPivoting: false,
    },
});
export function useNestedExpressionContainer() {
    return React.useContext(NestedExpressionContainerContext);
}
export function usePivotAwareNestedExpressionContainer(isPivoting) {
    const nestedExpressionContainer = useNestedExpressionContainer();
    const [pivotAwareExpressionContainer, setPivotAwareNestedExpressionContainer] = useState(nestedExpressionContainer);
    useEffect(() => {
        setPivotAwareNestedExpressionContainer((prev) => {
            return isPivoting ? prev : nestedExpressionContainer;
        });
    }, [isPivoting, nestedExpressionContainer]);
    return pivotAwareExpressionContainer;
}
//# sourceMappingURL=NestedExpressionContainerContext.js.map