import { jsx as _jsx } from "react/jsx-runtime";
import { useEffect } from "react";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { InlineEditableTextInput } from "../../table/BeeTable/InlineEditableTextInput";
import { useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
export function IteratorExpressionVariableCell({ rowIndex, columnIndex, currentElementId, data, beeTableRef, }) {
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const { isActive } = useBeeTableSelectableCellRef(rowIndex !== null && rowIndex !== void 0 ? rowIndex : 0, columnIndex !== null && columnIndex !== void 0 ? columnIndex : 0, undefined);
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject(`${currentElementId}-iteratorVariable`);
        }
    }, [beeGwtService, isActive, currentElementId]);
    return (_jsx("div", Object.assign({ style: {
            minHeight: "60px",
            display: "flex",
            alignItems: "center",
            justifyContent: "center",
        } }, { children: _jsx(InlineEditableTextInput, { value: data[rowIndex].child, onChange: (updatedValue) => {
                setExpression((prev) => {
                    const ret = Object.assign(Object.assign({}, prev), { "@_iteratorVariable": updatedValue });
                    return ret;
                });
            }, rowIndex: rowIndex, columnIndex: columnIndex, setActiveCellEditing: (value) => {
                var _a;
                (_a = beeTableRef.current) === null || _a === void 0 ? void 0 : _a.setActiveCellEditing(value);
            } }) })));
}
//# sourceMappingURL=IteratorExpressionVariableCell.js.map