import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useMemo } from "react";
import { NestedExpressionDispatchContextProvider, useBoxedExpressionEditorDispatch, } from "../../BoxedExpressionEditorContext";
import { ExpressionContainer } from "../ExpressionDefinitionRoot/ExpressionContainer";
export function IteratorExpressionCell({ rowIndex, columnIndex, parentElementId, iteratorClause, }) {
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const onSetExpression = useCallback(({ getNewExpression }) => {
        setExpression((prev) => {
            switch (rowIndex) {
                case 1:
                    return Object.assign(Object.assign({}, prev), { in: {
                            expression: getNewExpression(prev.in.expression),
                        } });
                case 2:
                default:
                    if (prev.__$$element === "for") {
                        return Object.assign(Object.assign({}, prev), { return: {
                                expression: getNewExpression(prev.return.expression),
                            } });
                    }
                    else {
                        return Object.assign(Object.assign({}, prev), { satisfies: {
                                expression: getNewExpression(prev.satisfies.expression),
                            } });
                    }
            }
        });
    }, [rowIndex, setExpression]);
    const currentExpression = useMemo(() => {
        var _a;
        if (typeof iteratorClause.child !== "string") {
            return (_a = iteratorClause.child) === null || _a === void 0 ? void 0 : _a.expression;
        }
    }, [iteratorClause.child]);
    return (_jsx(NestedExpressionDispatchContextProvider, Object.assign({ onSetExpression: onSetExpression }, { children: _jsx(ExpressionContainer, { expression: currentExpression, isResetSupported: true, isNested: true, rowIndex: rowIndex, columnIndex: columnIndex, parentElementId: parentElementId, parentElementTypeRef: undefined }) })));
}
//# sourceMappingURL=IteratorExpressionCell.js.map