import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useEffect, useRef } from "react";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { generateUuid } from "../../api";
import { findAllIdsDeep } from "../../ids/ids";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import { useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
import { ExpressionDefinitionLogicTypeSelector } from "./ExpressionDefinitionLogicTypeSelector";
export const ExpressionContainer = ({ expression, isNested, isResetSupported, rowIndex, columnIndex, parentElementId, parentElementTypeRef, parentElementName, }) => {
    const containerRef = useRef(null);
    const { beeGwtService, expressionHolderId, hideDmn14BoxedExpressions } = useBoxedExpressionEditor();
    const { setExpression, setWidthsById } = useBoxedExpressionEditorDispatch();
    const { isActive } = useBeeTableSelectableCellRef(rowIndex, columnIndex, undefined);
    useEffect(() => {
        if (isActive) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject(expression === null || expression === void 0 ? void 0 : expression["@_id"]);
        }
    }, [beeGwtService, isActive, expression]);
    const expressionTypeRef = expression === null || expression === void 0 ? void 0 : expression["@_typeRef"];
    const onLogicTypeSelected = useCallback((logicType) => {
        const { expression: defaultExpression, widthsById: defaultWidthsById } = beeGwtService.getDefaultExpressionDefinition(logicType, parentElementTypeRef !== null && parentElementTypeRef !== void 0 ? parentElementTypeRef : expressionTypeRef, !isNested);
        setExpression((prev) => {
            var _a, _b, _c;
            const ret = Object.assign(Object.assign({}, defaultExpression), { "@_id": (_a = defaultExpression["@_id"]) !== null && _a !== void 0 ? _a : generateUuid(), "@_label": (_c = (_b = defaultExpression["@_label"]) !== null && _b !== void 0 ? _b : parentElementName) !== null && _c !== void 0 ? _c : DEFAULT_EXPRESSION_VARIABLE_NAME });
            return ret;
        });
        setWidthsById(({ newMap }) => {
            defaultWidthsById.forEach((value, id) => {
                newMap.set(id, value);
            });
        });
    }, [beeGwtService, expressionTypeRef, parentElementName, isNested, parentElementTypeRef, setExpression, setWidthsById]);
    const onLogicTypeReset = useCallback(() => {
        setWidthsById(({ newMap }) => {
            for (const id of findAllIdsDeep(expression)) {
                newMap.delete(id);
            }
        });
        setExpression(undefined);
    }, [expression, setExpression, setWidthsById]);
    const getPlacementRef = useCallback(() => containerRef.current, []);
    return (_jsx("div", Object.assign({ ref: containerRef, className: "expression-container-box", "data-testid": "expression-container" }, { children: _jsx(ExpressionDefinitionLogicTypeSelector, { expression: expression, onLogicTypeSelected: onLogicTypeSelected, onLogicTypeReset: onLogicTypeReset, getPlacementRef: getPlacementRef, isResetSupported: isResetSupported, isNested: isNested, parentElementId: parentElementId !== null && parentElementId !== void 0 ? parentElementId : expressionHolderId, hideDmn14BoxedExpressions: hideDmn14BoxedExpressions }) })));
};
//# sourceMappingURL=ExpressionContainer.js.map