import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback } from "react";
import { NestedExpressionDispatchContextProvider, useBoxedExpressionEditorDispatch, } from "../../BoxedExpressionEditorContext";
import { ExpressionContainer } from "../ExpressionDefinitionRoot/ExpressionContainer";
import { solveResultAndEntriesIndex } from "./ContextExpression";
export function ContextResultExpressionCell(props) {
    var _a, _b;
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const { resultIndex } = solveResultAndEntriesIndex({
        contextEntries: (_a = props.contextExpression.contextEntry) !== null && _a !== void 0 ? _a : [],
        rowIndex: props.rowIndex,
    });
    const onSetExpression = useCallback(({ getNewExpression }) => {
        setExpression((prev) => {
            var _a, _b, _c, _d;
            const newContextEntries = [...((_a = prev.contextEntry) !== null && _a !== void 0 ? _a : [])];
            const newExpression = getNewExpression((_b = newContextEntries[resultIndex]) === null || _b === void 0 ? void 0 : _b.expression);
            if (resultIndex <= -1) {
                newContextEntries.push({
                    expression: newExpression,
                });
            }
            else if (newExpression) {
                newContextEntries.splice(resultIndex, 1, Object.assign(Object.assign({}, newContextEntries[resultIndex]), { expression: newExpression }));
            }
            else {
                newContextEntries.splice(resultIndex, 1);
            }
            const ret = Object.assign(Object.assign({}, prev), { contextEntry: newContextEntries, "@_label": (_c = newExpression === null || newExpression === void 0 ? void 0 : newExpression["@_label"]) !== null && _c !== void 0 ? _c : prev["@_label"], "@_typeRef": (_d = newExpression === null || newExpression === void 0 ? void 0 : newExpression["@_typeRef"]) !== null && _d !== void 0 ? _d : prev["@_typeRef"] });
            return ret;
        });
    }, [resultIndex, setExpression]);
    const resultEntry = resultIndex <= -1 ? undefined : (_b = props.contextExpression.contextEntry) === null || _b === void 0 ? void 0 : _b[resultIndex];
    return (_jsx(NestedExpressionDispatchContextProvider, Object.assign({ onSetExpression: onSetExpression }, { children: _jsx(ExpressionContainer, { expression: resultEntry === null || resultEntry === void 0 ? void 0 : resultEntry.expression, isResetSupported: true, isNested: true, rowIndex: resultIndex, columnIndex: props.columnIndex, parentElementId: props.contextExpression["@_id"], parentElementTypeRef: props.contextExpression["@_typeRef"], parentElementName: props.contextExpression["@_label"] }) })));
}
//# sourceMappingURL=ContextResultExpressionCell.js.map