import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useEffect, useMemo } from "react";
import { DmnBuiltInDataType } from "../api";
import { useCellWidthToFitDataRef } from "../resizing/BeeTableCellWidthToFitDataContext";
import { getCanvasFont, getTextWidth } from "../resizing/WidthsToFitData";
import { useBeeTableSelectableCellRef } from "../selection/BeeTableSelectionContext";
import { useBoxedExpressionEditor } from "../BoxedExpressionEditorContext";
import { DEFAULT_EXPRESSION_VARIABLE_NAME, ExpressionVariableMenu, } from "./ExpressionVariableMenu";
import "./ExpressionVariableCell.css";
export const ExpressionVariableCell = ({ data, rowIndex, columnIndex, onExpressionWithVariableUpdated }) => {
    var _a, _b;
    const ref = React.useRef(null);
    const { expression, variable, index } = data[rowIndex];
    const onVariableUpdated = useCallback(({ name = DEFAULT_EXPRESSION_VARIABLE_NAME, typeRef = undefined }) => {
        onExpressionWithVariableUpdated(index, {
            expression: expression
                ? Object.assign(Object.assign({}, expression), { "@_label": name, "@_typeRef": typeRef }) : undefined,
            variable: Object.assign(Object.assign({}, variable), { "@_name": name, "@_typeRef": typeRef }),
        });
    }, [onExpressionWithVariableUpdated, index, expression, variable]);
    useCellWidthToFitDataRef(rowIndex, columnIndex, useMemo(() => ({
        getWidthToFitData: () => {
            var _a, _b;
            const name = ref.current.querySelector(".expression-info-name");
            const typeRef = ref.current.querySelector(".expression-info-data-type");
            const padding = 8 * 2;
            const border = 2;
            return (padding +
                border +
                Math.max(getTextWidth((_a = name.textContent) !== null && _a !== void 0 ? _a : "", getCanvasFont(name)), getTextWidth((_b = typeRef.textContent) !== null && _b !== void 0 ? _b : "", getCanvasFont(typeRef))));
        },
    }), []));
    const { isActive } = useBeeTableSelectableCellRef(rowIndex, columnIndex, undefined, useCallback(() => `${variable["@_name"]} (${variable["@_typeRef"]}})`, [variable]));
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject(variable["@_id"]);
        }
    }, [beeGwtService, variable, isActive]);
    return (_jsx("div", Object.assign({ className: "expression-variable-cell" }, { children: _jsx("div", Object.assign({ className: `${variable["@_id"]} expression-variable` }, { children: _jsx(ExpressionVariableMenu, Object.assign({ selectedExpressionName: variable["@_name"], selectedDataType: variable["@_typeRef"], onVariableUpdated: onVariableUpdated }, { children: _jsxs("div", Object.assign({ className: `expression-info with-popover-menu`, ref: ref }, { children: [_jsx("p", Object.assign({ className: "expression-info-name pf-u-text-truncate", title: variable["@_name"], "data-ouia-component-id": "expression-info-name" }, { children: variable["@_name"] })), _jsxs("p", Object.assign({ className: "expression-info-data-type pf-u-text-truncate", title: (_a = variable["@_typeRef"]) !== null && _a !== void 0 ? _a : DmnBuiltInDataType.Undefined, "data-ouia-component-id": "expression-info-data-type" }, { children: ["(", (_b = variable["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined, ")"] }))] })) })) })) })));
};
//# sourceMappingURL=ExpressionVariableCell.js.map