import { jsx as _jsx } from "react/jsx-runtime";
import { Select, SelectGroup, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import * as React from "react";
import { useCallback, useMemo, useRef, useState } from "react";
import { useBoxedExpressionEditorI18n } from "../i18n";
import * as _ from "lodash";
import { DmnBuiltInDataType } from "../api";
import { useBoxedExpressionEditor } from "../BoxedExpressionEditorContext";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
const DEFAULT_SELECT_DATA_TYPE_MENU_HEIGHT = 500;
const MININAL_SELECT_DATA_TYPE_MENU_HEIGHT = 70;
const POPUP_BOTTOM_MARGIN = 46;
export const DataTypeSelector = ({ value, onChange, menuAppendTo, onToggle = () => { }, onKeyDown = () => { }, }) => {
    var _a;
    const { i18n } = useBoxedExpressionEditorI18n();
    const { dataTypes } = useBoxedExpressionEditor();
    const [isOpen, setOpen] = useState(false);
    const selectContainerRef = useRef(null);
    const onSelect = useCallback((event, selection) => {
        var _a, _b;
        setTimeout(() => setOpen(false), 0);
        onChange(selection === DmnBuiltInDataType.Undefined ? undefined : selection);
        (_b = (_a = selectContainerRef.current) === null || _a === void 0 ? void 0 : _a.querySelector("button")) === null || _b === void 0 ? void 0 : _b.focus();
    }, [onChange]);
    const buildSelectGroup = useCallback((group, options) => {
        return (_jsx(SelectGroup, Object.assign({ label: i18n.dataTypeDropDown[group] }, { children: options.map(({ name }) => (_jsx(SelectOption, { value: name, "data-ouia-component-id": name }, name))) }), group));
    }, [i18n]);
    const buildSelectGroups = useCallback(() => {
        const [customDataTypes, builtInDataTypes] = _.chain(dataTypes).partition("isCustom").value();
        if (_.isEmpty(customDataTypes)) {
            return [buildSelectGroup("builtIn", builtInDataTypes)];
        }
        return [
            buildSelectGroup("builtIn", builtInDataTypes),
            _jsx(Divider, {}, "divider"),
            buildSelectGroup("custom", customDataTypes),
        ];
    }, [buildSelectGroup, dataTypes]);
    const onFilter = useCallback((_, textInput) => {
        if (textInput === "") {
            return buildSelectGroups();
        }
        return buildSelectGroups().reduce((acc, group) => {
            var _a, _b, _c, _d;
            const filteredGroup = React.cloneElement(group, {
                children: (_b = (_a = group.props) === null || _a === void 0 ? void 0 : _a.children) === null || _b === void 0 ? void 0 : _b.filter((item) => { var _a; return ((_a = item.props.value) !== null && _a !== void 0 ? _a : DmnBuiltInDataType.Undefined).toLowerCase().includes(textInput.toLowerCase()); }),
            });
            if (((_d = (_c = filteredGroup.props) === null || _c === void 0 ? void 0 : _c.children) === null || _d === void 0 ? void 0 : _d.length) > 0) {
                acc.push(filteredGroup);
            }
            return acc;
        }, []);
    }, [buildSelectGroups]);
    const onSelectToggle = useCallback((isOpen) => {
        setOpen(isOpen);
        onToggle(isOpen);
    }, [onToggle]);
    const boundingClientRect = (_a = selectContainerRef.current) === null || _a === void 0 ? void 0 : _a.getBoundingClientRect();
    const selectMenuHeight = useMemo(() => {
        if (boundingClientRect) {
            const yPos = boundingClientRect.top;
            const availableHeight = document.documentElement.clientHeight;
            if (DEFAULT_SELECT_DATA_TYPE_MENU_HEIGHT <= availableHeight &&
                DEFAULT_SELECT_DATA_TYPE_MENU_HEIGHT + yPos > availableHeight) {
                const offset = DEFAULT_SELECT_DATA_TYPE_MENU_HEIGHT + yPos - availableHeight;
                const calculatedHeight = DEFAULT_SELECT_DATA_TYPE_MENU_HEIGHT - offset - POPUP_BOTTOM_MARGIN;
                return calculatedHeight < MININAL_SELECT_DATA_TYPE_MENU_HEIGHT
                    ? MININAL_SELECT_DATA_TYPE_MENU_HEIGHT
                    : calculatedHeight;
            }
        }
        return DEFAULT_SELECT_DATA_TYPE_MENU_HEIGHT;
    }, [boundingClientRect]);
    return (_jsx("div", Object.assign({ ref: selectContainerRef, onKeyDown: onKeyDown }, { children: _jsx(Select, Object.assign({ onKeyDown: (e) => e.stopPropagation(), menuAppendTo: menuAppendTo, ouiaId: "edit-expression-data-type", variant: SelectVariant.single, typeAheadAriaLabel: i18n.choose, onToggle: onSelectToggle, onSelect: onSelect, onFilter: onFilter, isOpen: isOpen, selections: value !== null && value !== void 0 ? value : DmnBuiltInDataType.Undefined, isGrouped: true, hasInlineFilter: true, inlineFilterPlaceholderText: i18n.choose, maxHeight: selectMenuHeight }, { children: buildSelectGroups() })) })));
};
//# sourceMappingURL=DataTypeSelector.js.map