"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.REGRESSION_MODEL = void 0;
var LocalTransformations_1 = require("./LocalTransformations");
var MiningSchema_1 = require("./MiningSchema");
var ModelExplanation_1 = require("./ModelExplanation");
var ModelStats_1 = require("./ModelStats");
var ModelVerification_1 = require("./ModelVerification");
var Output_1 = require("./Output");
var Targets_1 = require("./Targets");
var NUMERIC_PREDICTOR = "[\n  $v.NumericPredictor ~> $map(function($v, $i) {\n    {\n      \"type\": \"element\", \n      \"name\": \"NumericPredictor\", \n      \"attributes\": {\n        \"name\": $v.name,\n        \"exponent\": $v.exponent,\n        \"coefficient\": $v.coefficient\n      }\n    }\n  })\n]";
var CATEGORICAL_PREDICTOR = "[\n  $v.CategoricalPredictor ~> $map(function($v, $i) {\n    {\n      \"type\": \"element\", \n      \"name\": \"CategoricalPredictor\", \n      \"attributes\": {\n        \"name\": $v.name,\n        \"value\": $v.value,\n        \"coefficient\": $v.coefficient\n      }\n    }\n  })\n]";
var PREDICTOR_TERM = "[\n  $v.PredictorTerm ~> $map(function($v, $i) {\n    $v\n  })\n]";
var REGRESSION_TABLE = "[\n  $v.RegressionTable ~> $map(function($v, $i) {\n    {\n      \"type\": \"element\", \n      \"name\": \"RegressionTable\", \n      \"attributes\": {\n        \"intercept\": $v.intercept,\n        \"targetCategory\": $v.targetCategory \n      },\n      \"elements\": $append(".concat(NUMERIC_PREDICTOR, ",\n                    $append(").concat(CATEGORICAL_PREDICTOR, ",\n                      $append([], ").concat(PREDICTOR_TERM, ")\n                    )\n                  )\n    }\n  })\n]");
exports.REGRESSION_MODEL = "[\n  models[(_type = \"RegressionModel\")] ~> $map(function($v, $i) {\n    {\n      \"type\": \"element\",\n      \"name\": \"RegressionModel\",\n      \"attributes\": {\n        \"modelName\": $v.modelName,\n        \"functionName\": $v.functionName,\n        \"algorithmName\": $v.algorithmName,\n        \"modelType\": $v.modelType,\n        \"targetFieldName\": $v.targetFieldName,\n        \"normalizationMethod\": $v.normalizationMethod,\n        \"isScorable\": $v.isScorable\n      },\n      \"elements\": $append(".concat(MiningSchema_1.MINING_SCHEMA, ",\n                    $append(").concat(Output_1.OUTPUT, ", \n                      $append(").concat(REGRESSION_TABLE, ", \n                        $append(").concat(ModelStats_1.MODEL_STATS, ",\n                          $append(").concat(ModelExplanation_1.MODEL_EXPLANATION, ",\n                            $append(").concat(ModelVerification_1.MODEL_VERIFICATION, ",\n                              $append(").concat(Targets_1.TARGETS, ",\n                                $append([], ").concat(LocalTransformations_1.LOCAL_TRANSFORMATIONS, ")\n                              )\n                            )\n                          )\n                        )\n                      )\n                    )\n                  )\n    }\n  })\n]");
//# sourceMappingURL=RegressionModel.js.map