export declare const SW_SPEC_WORKFLOW_SCHEMA: {
    $id: string;
    $schema: string;
    description: string;
    type: string;
    properties: {
        id: {
            type: string;
            description: string;
            minLength: number;
        };
        key: {
            type: string;
            description: string;
            minLength: number;
        };
        name: {
            type: string;
            description: string;
            minLength: number;
        };
        description: {
            type: string;
            description: string;
        };
        version: {
            type: string;
            description: string;
            minLength: number;
        };
        annotations: {
            type: string;
            description: string;
            minItems: number;
            items: {
                type: string;
            };
            additionalItems: boolean;
        };
        dataInputSchema: {
            oneOf: ({
                type: string;
                description: string;
                minLength: number;
                properties?: undefined;
                additionalProperties?: undefined;
                required?: undefined;
            } | {
                type: string;
                description: string;
                properties: {
                    schema: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    failOnValidationErrors: {
                        type: string;
                        default: boolean;
                        description: string;
                    };
                };
                additionalProperties: boolean;
                required: string[];
                minLength?: undefined;
            })[];
        };
        secrets: {
            $ref: string;
        };
        constants: {
            oneOf: ({
                type: string;
                format: string;
                description: string;
            } | {
                type: string;
                description: string;
                format?: undefined;
            })[];
        };
        start: {
            $ref: string;
        };
        specVersion: {
            type: string;
            description: string;
            minLength: number;
        };
        expressionLang: {
            type: string;
            description: string;
            default: string;
            minLength: number;
        };
        timeouts: {
            $ref: string;
        };
        errors: {
            $ref: string;
        };
        keepActive: {
            type: string;
            default: boolean;
            description: string;
        };
        metadata: {
            $ref: string;
        };
        events: {
            $ref: string;
        };
        functions: {
            $ref: string;
        };
        autoRetries: {
            type: string;
            default: boolean;
            description: string;
        };
        retries: {
            $ref: string;
        };
        auth: {
            $ref: string;
        };
        states: {
            type: string;
            description: string;
            items: {
                anyOf: {
                    title: string;
                    $ref: string;
                }[];
            };
            additionalItems: boolean;
            minItems: number;
        };
    };
    oneOf: {
        required: string[];
    }[];
    definitions: {
        sleep: {
            type: string;
            properties: {
                before: {
                    type: string;
                    description: string;
                };
                after: {
                    type: string;
                    description: string;
                };
            };
            oneOf: {
                required: string[];
            }[];
        };
        crondef: {
            oneOf: ({
                type: string;
                description: string;
                minLength: number;
                properties?: undefined;
                additionalProperties?: undefined;
                required?: undefined;
            } | {
                type: string;
                properties: {
                    expression: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    validUntil: {
                        type: string;
                        description: string;
                    };
                };
                additionalProperties: boolean;
                required: string[];
                description?: undefined;
                minLength?: undefined;
            })[];
        };
        continueasdef: {
            oneOf: ({
                type: string;
                description: string;
                minLength: number;
                properties?: undefined;
                required?: undefined;
            } | {
                type: string;
                properties: {
                    workflowId: {
                        type: string;
                        description: string;
                    };
                    version: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    data: {
                        type: string[];
                        description: string;
                    };
                    workflowExecTimeout: {
                        $ref: string;
                        description: string;
                    };
                };
                required: string[];
                description?: undefined;
                minLength?: undefined;
            })[];
        };
        transition: {
            oneOf: ({
                type: string;
                description: string;
                minLength: number;
                properties?: undefined;
                additionalProperties?: undefined;
                required?: undefined;
            } | {
                type: string;
                description: string;
                properties: {
                    nextState: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    produceEvents: {
                        type: string;
                        description: string;
                        items: {
                            type: string;
                            $ref: string;
                        };
                        additionalItems: boolean;
                    };
                    compensate: {
                        type: string;
                        default: boolean;
                        description: string;
                    };
                };
                additionalProperties: boolean;
                required: string[];
                minLength?: undefined;
            })[];
        };
        error: {
            type: string;
            properties: {
                errorRef: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                errorRefs: {
                    type: string;
                    description: string;
                    minItems: number;
                    items: {
                        type: string;
                    };
                    additionalItems: boolean;
                };
                transition: {
                    description: string;
                    $ref: string;
                };
                end: {
                    description: string;
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            oneOf: {
                required: string[];
            }[];
        };
        onevents: {
            type: string;
            properties: {
                eventRefs: {
                    type: string;
                    description: string;
                    minItems: number;
                    items: {
                        type: string;
                    };
                    uniqueItems: boolean;
                    additionalItems: boolean;
                };
                actionMode: {
                    type: string;
                    enum: string[];
                    description: string;
                    default: string;
                };
                actions: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                eventDataFilter: {
                    description: string;
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        action: {
            type: string;
            properties: {
                id: {
                    type: string;
                    description: string;
                };
                name: {
                    type: string;
                    description: string;
                };
                functionRef: {
                    description: string;
                    $ref: string;
                };
                eventRef: {
                    description: string;
                    $ref: string;
                };
                subFlowRef: {
                    description: string;
                    $ref: string;
                };
                sleep: {
                    description: string;
                    $ref: string;
                };
                retryRef: {
                    type: string;
                    description: string;
                };
                nonRetryableErrors: {
                    type: string;
                    description: string;
                    minItems: number;
                    items: {
                        type: string;
                    };
                    additionalItems: boolean;
                };
                retryableErrors: {
                    type: string;
                    description: string;
                    minItems: number;
                    items: {
                        type: string;
                    };
                    additionalItems: boolean;
                };
                actionDataFilter: {
                    description: string;
                    $ref: string;
                };
                condition: {
                    description: string;
                    type: string;
                    minLength: number;
                };
            };
            additionalProperties: boolean;
            oneOf: {
                required: string[];
            }[];
        };
        functionref: {
            oneOf: ({
                type: string;
                description: string;
                minLength: number;
                properties?: undefined;
                additionalProperties?: undefined;
                required?: undefined;
            } | {
                type: string;
                description: string;
                properties: {
                    refName: {
                        type: string;
                        description: string;
                    };
                    arguments: {
                        type: string;
                        description: string;
                    };
                    selectionSet: {
                        type: string;
                        description: string;
                    };
                    invoke: {
                        type: string;
                        enum: string[];
                        description: string;
                        default: string;
                    };
                };
                additionalProperties: boolean;
                required: string[];
                minLength?: undefined;
            })[];
        };
        eventref: {
            type: string;
            description: string;
            properties: {
                triggerEventRef: {
                    type: string;
                    description: string;
                };
                resultEventRef: {
                    type: string;
                    description: string;
                };
                resultEventTimeout: {
                    type: string;
                    description: string;
                };
                data: {
                    type: string[];
                    description: string;
                };
                contextAttributes: {
                    type: string;
                    description: string;
                    additionalProperties: {
                        type: string;
                    };
                };
                invoke: {
                    type: string;
                    enum: string[];
                    description: string;
                    default: string;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        subflowref: {
            oneOf: ({
                type: string;
                description: string;
                minLength: number;
                properties?: undefined;
                required?: undefined;
            } | {
                type: string;
                description: string;
                properties: {
                    workflowId: {
                        type: string;
                        description: string;
                    };
                    version: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    onParentComplete: {
                        type: string;
                        enum: string[];
                        description: string;
                        default: string;
                    };
                    invoke: {
                        type: string;
                        enum: string[];
                        description: string;
                        default: string;
                    };
                };
                required: string[];
                minLength?: undefined;
            })[];
        };
        branch: {
            type: string;
            description: string;
            properties: {
                name: {
                    type: string;
                    description: string;
                };
                timeouts: {
                    type: string;
                    description: string;
                    properties: {
                        actionExecTimeout: {
                            $ref: string;
                        };
                        branchExecTimeout: {
                            $ref: string;
                        };
                    };
                    required: never[];
                };
                actions: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        sleepstate: {
            type: string;
            description: string;
            properties: {
                id: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                name: {
                    type: string;
                    description: string;
                };
                type: {
                    type: string;
                    const: string;
                    description: string;
                };
                end: {
                    $ref: string;
                    description: string;
                };
                stateDataFilter: {
                    description: string;
                    $ref: string;
                };
                duration: {
                    type: string;
                    description: string;
                };
                timeouts: {
                    type: string;
                    description: string;
                    properties: {
                        stateExecTimeout: {
                            $ref: string;
                        };
                    };
                    required: never[];
                };
                onErrors: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                transition: {
                    description: string;
                    $ref: string;
                };
                compensatedBy: {
                    type: string;
                    minLength: number;
                    description: string;
                };
                usedForCompensation: {
                    type: string;
                    default: boolean;
                    description: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            if: {
                properties: {
                    usedForCompensation: {
                        const: boolean;
                    };
                };
                required: string[];
            };
            then: {
                required: string[];
            };
            else: {
                oneOf: {
                    required: string[];
                }[];
            };
        };
        eventstate: {
            type: string;
            description: string;
            properties: {
                id: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                name: {
                    type: string;
                    description: string;
                };
                type: {
                    type: string;
                    const: string;
                    description: string;
                };
                exclusive: {
                    type: string;
                    default: boolean;
                    description: string;
                };
                onEvents: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                timeouts: {
                    type: string;
                    description: string;
                    properties: {
                        stateExecTimeout: {
                            $ref: string;
                        };
                        actionExecTimeout: {
                            $ref: string;
                        };
                        eventTimeout: {
                            $ref: string;
                        };
                    };
                    required: never[];
                };
                stateDataFilter: {
                    description: string;
                    $ref: string;
                };
                onErrors: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                transition: {
                    description: string;
                    $ref: string;
                };
                end: {
                    $ref: string;
                    description: string;
                };
                compensatedBy: {
                    type: string;
                    minLength: number;
                    description: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            oneOf: {
                required: string[];
            }[];
        };
        operationstate: {
            type: string;
            description: string;
            properties: {
                id: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                name: {
                    type: string;
                    description: string;
                };
                type: {
                    type: string;
                    const: string;
                    description: string;
                };
                end: {
                    $ref: string;
                    description: string;
                };
                stateDataFilter: {
                    description: string;
                    $ref: string;
                };
                actionMode: {
                    type: string;
                    enum: string[];
                    description: string;
                    default: string;
                };
                actions: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                };
                timeouts: {
                    type: string;
                    description: string;
                    properties: {
                        stateExecTimeout: {
                            $ref: string;
                        };
                        actionExecTimeout: {
                            $ref: string;
                        };
                    };
                    required: never[];
                };
                onErrors: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                transition: {
                    description: string;
                    $ref: string;
                };
                compensatedBy: {
                    type: string;
                    minLength: number;
                    description: string;
                };
                usedForCompensation: {
                    type: string;
                    default: boolean;
                    description: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            if: {
                properties: {
                    usedForCompensation: {
                        const: boolean;
                    };
                };
                required: string[];
            };
            then: {
                required: string[];
            };
            else: {
                oneOf: {
                    required: string[];
                }[];
            };
        };
        parallelstate: {
            type: string;
            description: string;
            properties: {
                id: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                name: {
                    type: string;
                    description: string;
                };
                type: {
                    type: string;
                    const: string;
                    description: string;
                };
                end: {
                    $ref: string;
                    description: string;
                };
                stateDataFilter: {
                    description: string;
                    $ref: string;
                };
                timeouts: {
                    type: string;
                    description: string;
                    properties: {
                        stateExecTimeout: {
                            $ref: string;
                        };
                        branchExecTimeout: {
                            $ref: string;
                        };
                    };
                    required: never[];
                };
                branches: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                completionType: {
                    type: string;
                    enum: string[];
                    description: string;
                    default: string;
                };
                numCompleted: {
                    type: string[];
                    minimum: number;
                    minLength: number;
                    description: string;
                };
                onErrors: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                transition: {
                    description: string;
                    $ref: string;
                };
                compensatedBy: {
                    type: string;
                    minLength: number;
                    description: string;
                };
                usedForCompensation: {
                    type: string;
                    default: boolean;
                    description: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            if: {
                properties: {
                    usedForCompensation: {
                        const: boolean;
                    };
                };
                required: string[];
            };
            then: {
                required: string[];
            };
            else: {
                oneOf: {
                    required: string[];
                }[];
            };
        };
        switchstate: {
            oneOf: {
                $ref: string;
            }[];
        };
        eventbasedswitchstate: {
            type: string;
            description: string;
            properties: {
                id: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                name: {
                    type: string;
                    description: string;
                };
                type: {
                    type: string;
                    const: string;
                    description: string;
                };
                stateDataFilter: {
                    description: string;
                    $ref: string;
                };
                timeouts: {
                    type: string;
                    description: string;
                    properties: {
                        stateExecTimeout: {
                            $ref: string;
                        };
                        eventTimeout: {
                            $ref: string;
                        };
                    };
                    required: never[];
                };
                eventConditions: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                onErrors: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                defaultCondition: {
                    description: string;
                    $ref: string;
                };
                compensatedBy: {
                    type: string;
                    minLength: number;
                    description: string;
                };
                usedForCompensation: {
                    type: string;
                    default: boolean;
                    description: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        databasedswitchstate: {
            type: string;
            description: string;
            properties: {
                id: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                name: {
                    type: string;
                    description: string;
                };
                type: {
                    type: string;
                    const: string;
                    description: string;
                };
                stateDataFilter: {
                    description: string;
                    $ref: string;
                };
                timeouts: {
                    type: string;
                    description: string;
                    properties: {
                        stateExecTimeout: {
                            $ref: string;
                        };
                    };
                    required: never[];
                };
                dataConditions: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                onErrors: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                defaultCondition: {
                    description: string;
                    $ref: string;
                };
                compensatedBy: {
                    type: string;
                    minLength: number;
                    description: string;
                };
                usedForCompensation: {
                    type: string;
                    default: boolean;
                    description: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        defaultconditiondef: {
            type: string;
            description: string;
            properties: {
                transition: {
                    $ref: string;
                };
                end: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            oneOf: {
                required: string[];
            }[];
        };
        eventcondition: {
            oneOf: {
                $ref: string;
            }[];
        };
        transitioneventcondition: {
            type: string;
            description: string;
            properties: {
                name: {
                    type: string;
                    description: string;
                };
                eventRef: {
                    type: string;
                    description: string;
                };
                transition: {
                    description: string;
                    $ref: string;
                };
                eventDataFilter: {
                    description: string;
                    $ref: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        enddeventcondition: {
            type: string;
            description: string;
            properties: {
                name: {
                    type: string;
                    description: string;
                };
                eventRef: {
                    type: string;
                    description: string;
                };
                end: {
                    $ref: string;
                    description: string;
                };
                eventDataFilter: {
                    description: string;
                    $ref: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        datacondition: {
            oneOf: {
                $ref: string;
            }[];
        };
        transitiondatacondition: {
            type: string;
            description: string;
            properties: {
                name: {
                    type: string;
                    description: string;
                };
                condition: {
                    type: string;
                    description: string;
                };
                transition: {
                    description: string;
                    $ref: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        enddatacondition: {
            type: string;
            description: string;
            properties: {
                name: {
                    type: string;
                    description: string;
                };
                condition: {
                    type: string;
                    description: string;
                };
                end: {
                    $ref: string;
                    description: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        injectstate: {
            type: string;
            description: string;
            properties: {
                id: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                name: {
                    type: string;
                    description: string;
                };
                type: {
                    type: string;
                    const: string;
                    description: string;
                };
                end: {
                    $ref: string;
                    description: string;
                };
                data: {
                    type: string;
                    description: string;
                };
                timeouts: {
                    type: string;
                    description: string;
                    properties: {
                        stateExecTimeout: {
                            $ref: string;
                        };
                    };
                    required: never[];
                };
                stateDataFilter: {
                    description: string;
                    $ref: string;
                };
                transition: {
                    description: string;
                    $ref: string;
                };
                compensatedBy: {
                    type: string;
                    minLength: number;
                    description: string;
                };
                usedForCompensation: {
                    type: string;
                    default: boolean;
                    description: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            if: {
                properties: {
                    usedForCompensation: {
                        const: boolean;
                    };
                };
                required: string[];
            };
            then: {
                required: string[];
            };
            else: {
                oneOf: {
                    required: string[];
                }[];
            };
        };
        foreachstate: {
            type: string;
            description: string;
            properties: {
                id: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                name: {
                    type: string;
                    description: string;
                };
                type: {
                    type: string;
                    const: string;
                    description: string;
                };
                end: {
                    $ref: string;
                    description: string;
                };
                inputCollection: {
                    type: string;
                    description: string;
                };
                outputCollection: {
                    type: string;
                    description: string;
                };
                iterationParam: {
                    type: string;
                    description: string;
                };
                batchSize: {
                    type: string[];
                    minimum: number;
                    minLength: number;
                    description: string;
                };
                actions: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                timeouts: {
                    type: string;
                    description: string;
                    properties: {
                        stateExecTimeout: {
                            $ref: string;
                        };
                        actionExecTimeout: {
                            $ref: string;
                        };
                    };
                    required: never[];
                };
                stateDataFilter: {
                    description: string;
                    $ref: string;
                };
                onErrors: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                transition: {
                    description: string;
                    $ref: string;
                };
                compensatedBy: {
                    type: string;
                    minLength: number;
                    description: string;
                };
                usedForCompensation: {
                    type: string;
                    default: boolean;
                    description: string;
                };
                mode: {
                    type: string;
                    enum: string[];
                    description: string;
                    default: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            if: {
                properties: {
                    usedForCompensation: {
                        const: boolean;
                    };
                };
                required: string[];
            };
            then: {
                required: string[];
            };
            else: {
                oneOf: {
                    required: string[];
                }[];
            };
        };
        callbackstate: {
            type: string;
            description: string;
            properties: {
                id: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                name: {
                    type: string;
                    description: string;
                };
                type: {
                    type: string;
                    const: string;
                    description: string;
                };
                action: {
                    description: string;
                    $ref: string;
                };
                eventRef: {
                    type: string;
                    description: string;
                };
                timeouts: {
                    type: string;
                    description: string;
                    properties: {
                        stateExecTimeout: {
                            $ref: string;
                        };
                        actionExecTimeout: {
                            $ref: string;
                        };
                        eventTimeout: {
                            $ref: string;
                        };
                    };
                    required: never[];
                };
                eventDataFilter: {
                    description: string;
                    $ref: string;
                };
                stateDataFilter: {
                    description: string;
                    $ref: string;
                };
                onErrors: {
                    type: string;
                    description: string;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                transition: {
                    description: string;
                    $ref: string;
                };
                end: {
                    $ref: string;
                    description: string;
                };
                compensatedBy: {
                    type: string;
                    minLength: number;
                    description: string;
                };
                usedForCompensation: {
                    type: string;
                    default: boolean;
                    description: string;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            if: {
                properties: {
                    usedForCompensation: {
                        const: boolean;
                    };
                };
                required: string[];
            };
            then: {
                required: string[];
            };
            else: {
                oneOf: {
                    required: string[];
                }[];
            };
        };
        startdef: {
            oneOf: ({
                type: string;
                description: string;
                minLength: number;
                properties?: undefined;
                additionalProperties?: undefined;
                required?: undefined;
            } | {
                type: string;
                description: string;
                properties: {
                    stateName: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    schedule: {
                        description: string;
                        $ref: string;
                    };
                };
                additionalProperties: boolean;
                required: string[];
                minLength?: undefined;
            })[];
        };
        schedule: {
            oneOf: ({
                type: string;
                description: string;
                minLength: number;
                properties?: undefined;
                additionalProperties?: undefined;
                oneOf?: undefined;
            } | {
                type: string;
                description: string;
                properties: {
                    interval: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    cron: {
                        $ref: string;
                    };
                    timezone: {
                        type: string;
                        description: string;
                    };
                };
                additionalProperties: boolean;
                oneOf: {
                    required: string[];
                }[];
                minLength?: undefined;
            })[];
        };
        end: {
            oneOf: ({
                type: string;
                description: string;
                default: boolean;
                properties?: undefined;
                additionalProperties?: undefined;
                required?: undefined;
            } | {
                type: string;
                description: string;
                properties: {
                    terminate: {
                        type: string;
                        default: boolean;
                        description: string;
                    };
                    produceEvents: {
                        type: string;
                        description: string;
                        items: {
                            type: string;
                            $ref: string;
                        };
                        additionalItems: boolean;
                    };
                    compensate: {
                        type: string;
                        default: boolean;
                        description: string;
                    };
                    continueAs: {
                        $ref: string;
                    };
                };
                additionalProperties: boolean;
                required: never[];
                default?: undefined;
            })[];
        };
        produceeventdef: {
            type: string;
            description: string;
            properties: {
                eventRef: {
                    type: string;
                    description: string;
                };
                data: {
                    type: string[];
                    description: string;
                };
                contextAttributes: {
                    type: string;
                    description: string;
                    additionalProperties: {
                        type: string;
                    };
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        statedatafilter: {
            type: string;
            properties: {
                input: {
                    type: string;
                    description: string;
                };
                output: {
                    type: string;
                    description: string;
                };
            };
            additionalProperties: boolean;
            required: never[];
        };
        eventdatafilter: {
            type: string;
            properties: {
                useData: {
                    type: string;
                    description: string;
                    default: boolean;
                };
                data: {
                    type: string;
                    description: string;
                };
                toStateData: {
                    type: string;
                    description: string;
                };
            };
            additionalProperties: boolean;
            required: never[];
        };
        actiondatafilter: {
            type: string;
            properties: {
                fromStateData: {
                    type: string;
                    description: string;
                };
                useResults: {
                    type: string;
                    description: string;
                    default: boolean;
                };
                results: {
                    type: string;
                    description: string;
                };
                toStateData: {
                    type: string;
                    description: string;
                };
            };
            additionalProperties: boolean;
            required: never[];
        };
        retrydef: {
            type: string;
            properties: {
                name: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                delay: {
                    type: string;
                    description: string;
                };
                maxDelay: {
                    type: string;
                    description: string;
                };
                increment: {
                    type: string;
                    description: string;
                };
                multiplier: {
                    type: string[];
                    minimum: number;
                    minLength: number;
                    multipleOf: number;
                    description: string;
                };
                maxAttempts: {
                    type: string[];
                    minimum: number;
                    minLength: number;
                    description: string;
                };
                jitter: {
                    type: string[];
                    minimum: number;
                    maximum: number;
                    description: string;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        function: {
            type: string;
            properties: {
                name: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                operation: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                type: {
                    type: string;
                    description: string;
                    enum: string[];
                    default: string;
                };
                authRef: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                metadata: {
                    $ref: string;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        metadata: {
            type: string;
            description: string;
            additionalProperties: {
                type: string;
            };
        };
        authdef: {
            type: string;
            properties: {
                name: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                scheme: {
                    type: string;
                    description: string;
                    enum: string[];
                    default: string;
                };
                properties: {
                    oneOf: ({
                        type: string;
                        description: string;
                        title?: undefined;
                        $ref?: undefined;
                    } | {
                        title: string;
                        $ref: string;
                        type?: undefined;
                        description?: undefined;
                    })[];
                };
            };
            required: string[];
        };
        basicpropsdef: {
            oneOf: ({
                type: string;
                description: string;
                properties?: undefined;
                required?: undefined;
                additionalProperties?: undefined;
            } | {
                type: string;
                description: string;
                properties: {
                    username: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    password: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    metadata: {
                        $ref: string;
                    };
                };
                required: string[];
                additionalProperties: boolean;
            })[];
        };
        bearerpropsdef: {
            oneOf: ({
                type: string;
                description: string;
                properties?: undefined;
                required?: undefined;
                additionalProperties?: undefined;
            } | {
                type: string;
                description: string;
                properties: {
                    token: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    metadata: {
                        $ref: string;
                    };
                };
                required: string[];
                additionalProperties: boolean;
            })[];
        };
        oauth2propsdef: {
            oneOf: ({
                type: string;
                description: string;
                properties?: undefined;
                required?: undefined;
            } | {
                type: string;
                description: string;
                properties: {
                    authority: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    grantType: {
                        type: string;
                        description: string;
                        enum: string[];
                        additionalItems: boolean;
                    };
                    clientId: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    clientSecret: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    scopes: {
                        type: string;
                        description: string;
                        items: {
                            type: string;
                        };
                        minItems: number;
                        additionalItems: boolean;
                    };
                    username: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    password: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    audiences: {
                        type: string;
                        description: string;
                        items: {
                            type: string;
                        };
                        minItems: number;
                        additionalItems: boolean;
                    };
                    subjectToken: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    requestedSubject: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    requestedIssuer: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    metadata: {
                        $ref: string;
                    };
                };
                required: string[];
            })[];
        };
        workflowExecTimeout: {
            oneOf: ({
                type: string;
                description: string;
                minLength: number;
                properties?: undefined;
                additionalProperties?: undefined;
                required?: undefined;
            } | {
                type: string;
                properties: {
                    duration: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    interrupt: {
                        type: string;
                        description: string;
                        default: boolean;
                    };
                    runBefore: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                };
                additionalProperties: boolean;
                required: string[];
                description?: undefined;
                minLength?: undefined;
            })[];
        };
        stateExecTimeout: {
            oneOf: ({
                type: string;
                description: string;
                minLength: number;
                properties?: undefined;
                additionalProperties?: undefined;
                required?: undefined;
            } | {
                type: string;
                description: string;
                properties: {
                    single: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                    total: {
                        type: string;
                        description: string;
                        minLength: number;
                    };
                };
                additionalProperties: boolean;
                required: string[];
                minLength?: undefined;
            })[];
        };
        actionExecTimeout: {
            type: string;
            description: string;
            minLength: number;
        };
        branchExecTimeout: {
            type: string;
            description: string;
            minLength: number;
        };
        eventTimeout: {
            type: string;
            description: string;
            minLength: number;
        };
        eventdef: {
            type: string;
            properties: {
                name: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                source: {
                    type: string;
                    description: string;
                };
                type: {
                    type: string;
                    description: string;
                };
                kind: {
                    type: string;
                    enum: string[];
                    description: string;
                    default: string;
                };
                correlation: {
                    type: string;
                    description: string;
                    minItems: number;
                    items: {
                        type: string;
                        $ref: string;
                    };
                    additionalItems: boolean;
                };
                dataOnly: {
                    type: string;
                    default: boolean;
                    description: string;
                };
                metadata: {
                    $ref: string;
                    description: string;
                };
            };
            additionalProperties: boolean;
            if: {
                properties: {
                    kind: {
                        const: string;
                    };
                };
            };
            then: {
                required: string[];
            };
            else: {
                required: string[];
            };
        };
        correlationDef: {
            type: string;
            description: string;
            properties: {
                contextAttributeName: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                contextAttributeValue: {
                    type: string;
                    description: string;
                    minLength: number;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        errordef: {
            type: string;
            properties: {
                name: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                code: {
                    type: string;
                    description: string;
                    minLength: number;
                };
                description: {
                    type: string;
                    description: string;
                };
            };
            additionalProperties: boolean;
            required: string[];
        };
        secrets: {
            oneOf: ({
                type: string;
                format: string;
                description: string;
                items?: undefined;
                minItems?: undefined;
            } | {
                type: string;
                description: string;
                items: {
                    type: string;
                };
                minItems: number;
                format?: undefined;
            })[];
        };
        timeouts: {
            oneOf: ({
                type: string;
                format: string;
                description: string;
                properties?: undefined;
                additionalProperties?: undefined;
                required?: undefined;
            } | {
                type: string;
                description: string;
                properties: {
                    workflowExecTimeout: {
                        $ref: string;
                    };
                    stateExecTimeout: {
                        $ref: string;
                    };
                    actionExecTimeout: {
                        $ref: string;
                    };
                    branchExecTimeout: {
                        $ref: string;
                    };
                    eventTimeout: {
                        $ref: string;
                    };
                };
                additionalProperties: boolean;
                required: never[];
                format?: undefined;
            })[];
        };
        errors: {
            oneOf: ({
                type: string;
                format: string;
                description: string;
                items?: undefined;
                additionalItems?: undefined;
                minItems?: undefined;
            } | {
                type: string;
                description: string;
                items: {
                    type: string;
                    $ref: string;
                };
                additionalItems: boolean;
                minItems: number;
                format?: undefined;
            })[];
        };
        events: {
            oneOf: ({
                type: string;
                format: string;
                description: string;
                items?: undefined;
                additionalItems?: undefined;
                minItems?: undefined;
            } | {
                type: string;
                description: string;
                items: {
                    type: string;
                    $ref: string;
                };
                additionalItems: boolean;
                minItems: number;
                format?: undefined;
            })[];
        };
        functions: {
            oneOf: ({
                type: string;
                format: string;
                description: string;
                items?: undefined;
                additionalItems?: undefined;
                minItems?: undefined;
            } | {
                type: string;
                description: string;
                items: {
                    type: string;
                    $ref: string;
                };
                additionalItems: boolean;
                minItems: number;
                format?: undefined;
            })[];
        };
        retries: {
            oneOf: ({
                type: string;
                format: string;
                description: string;
                items?: undefined;
                additionalItems?: undefined;
                minItems?: undefined;
            } | {
                type: string;
                description: string;
                items: {
                    type: string;
                    $ref: string;
                };
                additionalItems: boolean;
                minItems: number;
                format?: undefined;
            })[];
        };
        auth: {
            oneOf: ({
                type: string;
                format: string;
                description: string;
                items?: undefined;
                additionalItems?: undefined;
                minItems?: undefined;
            } | {
                type: string;
                description: string;
                items: {
                    type: string;
                    $ref: string;
                };
                additionalItems: boolean;
                minItems: number;
                format?: undefined;
            })[];
        };
    };
};
//# sourceMappingURL=workflow.d.ts.map