"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerlessWorkflowTextEditor = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var React = require("react");
var react_1 = require("react");
var api_1 = require("@kie-tools-core/workspace/dist/api");
var SwfTextEditorController_1 = require("./textEditor/SwfTextEditorController");
var SwfTextEditor_1 = require("./textEditor/SwfTextEditor");
var api_2 = require("@kie-tools-core/editor/dist/api");
var RefForwardingServerlessWorkflowTextEditor = function (props, forwardedRef) {
    var onStateControlCommandUpdate = props.onStateControlCommandUpdate, onNewEdit = props.onNewEdit;
    var _a = __read((0, react_1.useState)(undefined), 2), initialContent = _a[0], setInitialContent = _a[1];
    var swfTextEditorRef = (0, react_1.useRef)(null);
    (0, react_1.useImperativeHandle)(forwardedRef, function () {
        return {
            setContent: function (normalizedPosixPathRelativeToTheWorkspaceRoot, newContent) {
                try {
                    setInitialContent({
                        originalContent: newContent,
                        normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot,
                    });
                    return Promise.resolve();
                }
                catch (e) {
                    console.error(e);
                    return Promise.reject();
                }
            },
            getContent: function () {
                var _a;
                return Promise.resolve(((_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.getContent()) || "");
            },
            getPreview: function () {
                return Promise.resolve("");
            },
            undo: function () { return __awaiter(void 0, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    if (!swfTextEditorRef.current) {
                        return [2];
                    }
                    swfTextEditorRef.current.undo();
                    onStateControlCommandUpdate(api_2.StateControlCommand.UNDO);
                    return [2];
                });
            }); },
            redo: function () { return __awaiter(void 0, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    if (!swfTextEditorRef.current) {
                        return [2];
                    }
                    swfTextEditorRef.current.redo();
                    onStateControlCommandUpdate(api_2.StateControlCommand.REDO);
                    return [2];
                });
            }); },
            validate: function () {
                return Promise.resolve([]);
            },
            setTheme: function (theme) {
                var _a;
                return ((_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.setTheme(theme)) || Promise.resolve();
            },
            moveCursorToNode: function (nodeName) {
                var _a;
                (_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.moveCursorToNode(nodeName);
            },
            moveCursorToPosition: function (position) {
                var _a;
                (_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.moveCursorToPosition(position);
            },
        };
    }, [onStateControlCommandUpdate]);
    var setValidationErrors = (0, react_1.useCallback)(function (errors) {
        if (!initialContent) {
            return;
        }
        var notifications = errors.map(function (error) { return ({
            type: "PROBLEM",
            normalizedPosixPathRelativeToTheWorkspaceRoot: initialContent.normalizedPosixPathRelativeToTheWorkspaceRoot,
            severity: "ERROR",
            message: "".concat(error.message),
            position: {
                startLineNumber: error.startLineNumber,
                startColumn: error.startColumn,
                endLineNumber: error.endLineNumber,
                endColumn: error.endColumn,
            },
        }); });
        props.setNotifications.apply(initialContent.normalizedPosixPathRelativeToTheWorkspaceRoot, notifications);
    }, [initialContent, props.setNotifications]);
    var isVscode = (0, react_1.useCallback)(function () {
        return props.channelType === api_2.ChannelType.VSCODE_DESKTOP || props.channelType === api_2.ChannelType.VSCODE_WEB;
    }, [props.channelType]);
    var onContentChanged = (0, react_1.useCallback)(function (args) {
        var _a, _b;
        switch (args.operation) {
            case SwfTextEditorController_1.SwfTextEditorOperation.EDIT:
                onNewEdit(new api_1.WorkspaceEdit(args.content));
                break;
            case SwfTextEditorController_1.SwfTextEditorOperation.UNDO:
                if (!isVscode()) {
                    (_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo();
                }
                onStateControlCommandUpdate(api_2.StateControlCommand.UNDO);
                break;
            case SwfTextEditorController_1.SwfTextEditorOperation.REDO:
                if (!isVscode()) {
                    (_b = swfTextEditorRef.current) === null || _b === void 0 ? void 0 : _b.redo();
                }
                onStateControlCommandUpdate(api_2.StateControlCommand.REDO);
                break;
        }
    }, [onNewEdit, isVscode, onStateControlCommandUpdate]);
    return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: initialContent && ((0, jsx_runtime_1.jsx)(SwfTextEditor_1.SwfTextEditor, { channelType: props.channelType, content: initialContent.originalContent, fileName: initialContent.normalizedPosixPathRelativeToTheWorkspaceRoot, onContentChange: onContentChanged, setValidationErrors: setValidationErrors, ref: swfTextEditorRef, isReadOnly: props.isReadOnly })) }));
};
exports.ServerlessWorkflowTextEditor = React.forwardRef(RefForwardingServerlessWorkflowTextEditor);
//# sourceMappingURL=ServerlessWorkflowTextEditor.js.map