"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenShiftService = void 0;
var Project_1 = require("../resources/openshift/Project");
var ResourceFetcher_1 = require("../fetch/ResourceFetcher");
var support_1 = require("./support");
var KubernetesService_1 = require("./KubernetesService");
var KubernetesConnection_1 = require("./KubernetesConnection");
var common_1 = require("../resources/common");
var OpenShiftService = (function () {
    function OpenShiftService(args) {
        this.args = args;
        this.kubernetesService = new KubernetesService_1.KubernetesService(args);
        this.knativeSupportService = new support_1.KnativeSupportService({
            fetcher: this.kubernetesService.fetcher,
            namespace: args.connection.namespace,
        });
    }
    Object.defineProperty(OpenShiftService.prototype, "knative", {
        get: function () {
            return this.knativeSupportService;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(OpenShiftService.prototype, "kubernetes", {
        get: function () {
            return this.kubernetesService;
        },
        enumerable: false,
        configurable: true
    });
    OpenShiftService.prototype.composeDeploymentUrlFromRoute = function (route) {
        return "https://".concat(route.spec.host);
    };
    OpenShiftService.prototype.extractDeploymentState = function (args) {
        var _a;
        if (args.build) {
            if (!args.build.status || ["Failed", "Error", "Cancelled"].includes(args.build.status.phase)) {
                return common_1.DeploymentState.DOWN;
            }
            if (["New", "Pending"].includes(args.build.status.phase)) {
                return common_1.DeploymentState.PREPARING;
            }
            if (args.build.status.phase === "Running") {
                return common_1.DeploymentState.IN_PROGRESS;
            }
        }
        if (!args.deployment || !args.deployment.status) {
            return common_1.DeploymentState.IN_PROGRESS;
        }
        if (!args.deployment.status.replicas) {
            return common_1.DeploymentState.DOWN;
        }
        var progressingCondition = (_a = args.deployment.status.conditions) === null || _a === void 0 ? void 0 : _a.find(function (condition) { return condition.type === "Progressing"; });
        if (!progressingCondition || progressingCondition.status !== "True") {
            return common_1.DeploymentState.DOWN;
        }
        if (!args.deployment.status.readyReplicas) {
            return common_1.DeploymentState.IN_PROGRESS;
        }
        return common_1.DeploymentState.UP;
    };
    OpenShiftService.prototype.withFetch = function (callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.kubernetes.withFetch(callback)];
            });
        });
    };
    OpenShiftService.prototype.isConnectionEstablished = function (connection) {
        return __awaiter(this, void 0, void 0, function () {
            var testConnectionFetcher, error_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        testConnectionFetcher = new ResourceFetcher_1.ResourceFetcher({ connection: connection, proxyUrl: this.args.proxyUrl });
                        return [4, testConnectionFetcher.execute({ target: new Project_1.GetProject({ namespace: connection.namespace }) })];
                    case 1:
                        _a.sent();
                        return [2, KubernetesConnection_1.KubernetesConnectionStatus.CONNECTED];
                    case 2:
                        error_1 = _a.sent();
                        return [2, KubernetesConnection_1.KubernetesConnectionStatus.ERROR];
                    case 3: return [2];
                }
            });
        });
    };
    OpenShiftService.prototype.newResourceName = function (prefix) {
        return this.kubernetes.newResourceName(prefix);
    };
    return OpenShiftService;
}());
exports.OpenShiftService = OpenShiftService;
//# sourceMappingURL=OpenShiftService.js.map