"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteSecret = exports.CreateSecret = exports.SECRET_TEMPLATE = void 0;
var ResourceFetch_1 = require("../../fetch/ResourceFetch");
var FetchConstants_1 = require("../../fetch/FetchConstants");
var v1_1 = require("kubernetes-models/v1");
var common_1 = require("../common");
var SECRET_TEMPLATE = function (args) {
    var encodedData = Object.entries(args.data).reduce(function (acc, _a) {
        var _b;
        var _c = __read(_a, 2), key = _c[0], value = _c[1];
        return (__assign(__assign({}, acc), (_b = {}, _b[key] = btoa(value), _b)));
    }, {});
    return new v1_1.Secret({
        metadata: {
            name: args.resourceName,
            namespace: args.namespace,
            labels: (0, common_1.commonLabels)(__assign({}, args)),
        },
        data: encodedData,
    }).toJSON();
};
exports.SECRET_TEMPLATE = SECRET_TEMPLATE;
var CreateSecret = (function (_super) {
    __extends(CreateSecret, _super);
    function CreateSecret(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    CreateSecret.prototype.method = function () {
        return FetchConstants_1.HttpMethod.POST;
    };
    CreateSecret.prototype.body = function () {
        return JSON.stringify(this.args.resourceDataSource === common_1.ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : (0, exports.SECRET_TEMPLATE)(__assign({}, this.args)));
    };
    CreateSecret.prototype.endpoint = function () {
        return "/api/".concat(v1_1.Secret.apiVersion, "/namespaces/").concat(this.args.namespace, "/secrets");
    };
    return CreateSecret;
}(ResourceFetch_1.ResourceFetch));
exports.CreateSecret = CreateSecret;
var DeleteSecret = (function (_super) {
    __extends(DeleteSecret, _super);
    function DeleteSecret(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    DeleteSecret.prototype.method = function () {
        return FetchConstants_1.HttpMethod.DELETE;
    };
    DeleteSecret.prototype.endpoint = function () {
        return "/api/".concat(v1_1.Secret.apiVersion, "/namespaces/").concat(this.args.namespace, "/secrets/").concat(this.args.resourceName);
    };
    return DeleteSecret;
}(ResourceFetch_1.ResourceFetch));
exports.DeleteSecret = DeleteSecret;
//# sourceMappingURL=Secret.js.map