"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isGistLikeWorkspaceKind = exports.isGitBasedWorkspaceKind = exports.WorkspaceKind = void 0;
var WorkspaceKind;
(function (WorkspaceKind) {
    WorkspaceKind["GITHUB_GIST"] = "GITHUB_GIST";
    WorkspaceKind["GIT"] = "GIT";
    WorkspaceKind["LOCAL"] = "LOCAL";
    WorkspaceKind["BITBUCKET_SNIPPET"] = "BITBUCKET_SNIPPET";
})(WorkspaceKind = exports.WorkspaceKind || (exports.WorkspaceKind = {}));
var gitBasedTypeKeys = [WorkspaceKind.GIT, WorkspaceKind.BITBUCKET_SNIPPET, WorkspaceKind.GITHUB_GIST];
var isGitBasedWorkspaceKind = function (maybeGitBasedType) {
    return gitBasedTypeKeys.some(function (k) { return k === maybeGitBasedType; });
};
exports.isGitBasedWorkspaceKind = isGitBasedWorkspaceKind;
var gistLikeTypeKeys = [WorkspaceKind.GITHUB_GIST, WorkspaceKind.BITBUCKET_SNIPPET];
var isGistLikeWorkspaceKind = function (maybeGistLikeType) {
    return gistLikeTypeKeys.some(function (k) { return k === maybeGistLikeType; });
};
exports.isGistLikeWorkspaceKind = isGistLikeWorkspaceKind;
//# sourceMappingURL=WorkspaceOrigin.js.map