import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Checkbox } from "@patternfly/react-core/dist/esm/components/Checkbox";
import { FormSelect, FormSelectOption } from "@patternfly/react-core/dist/esm/components/FormSelect";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { TestScenarioType } from "../TestScenarioEditor";
import { useTestScenarioEditorI18n } from "../i18n";
import { HelpIcon } from "@patternfly/react-icons/dist/esm/icons/help-icon";
import { Icon } from "@patternfly/react-core/dist/esm/components/Icon/Icon";
import { Tooltip } from "@patternfly/react-core/dist/esm/components/Tooltip";
import "./TestScenarioDrawerSettingsPanel.css";
function TestScenarioDrawerSettingsPanel({ fileName, onUpdateSettingField, testScenarioSettings, }) {
    const { i18n } = useTestScenarioEditorI18n();
    return (_jsxs(_Fragment, { children: [_jsx(Title, Object.assign({ className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6" }, { children: i18n.drawer.settings.fileName })), _jsx(TextInput, { className: "kie-scesim-editor-drawer-settings--text-input", value: fileName, type: "text", isDisabled: true }), _jsx(Title, Object.assign({ className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6" }, { children: i18n.drawer.settings.assetType })), _jsx(TextInput, { className: "kie-scesim-editor-drawer-settings--text-input", value: testScenarioSettings.assetType, type: "text", isDisabled: true }), testScenarioSettings.assetType === TestScenarioType[TestScenarioType.DMN] ? (_jsxs(_Fragment, { children: [_jsx(Title, Object.assign({ className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6" }, { children: i18n.drawer.settings.dmnModel })), _jsxs(FormSelect, Object.assign({ className: "kie-scesim-editor-drawer-settings--form-select", value: "1", "aria-label": "FormSelect Input", ouiaId: "BasicFormSelect" }, { children: [_jsx(FormSelectOption, { isDisabled: true, value: "1", label: "MockedDMN.dmn" }, 0), _jsx(FormSelectOption, { isDisabled: true, value: "2", label: "MockedDMN2.dmn" }, 1)] })), _jsx(Title, Object.assign({ className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6" }, { children: i18n.drawer.settings.dmnName })), _jsx(TextInput, { className: "kie-scesim-editor-drawer-settings--text-input", value: testScenarioSettings.dmnName, type: "text", isDisabled: true }), _jsx(Title, Object.assign({ className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6" }, { children: i18n.drawer.settings.dmnNameSpace })), _jsx(TextInput, { className: "kie-scesim-editor-drawer-settings--text-input", value: testScenarioSettings.dmnNamespace, type: "text", isDisabled: true })] })) : (_jsxs(_Fragment, { children: [_jsxs(Title, Object.assign({ className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6" }, { children: [i18n.drawer.settings.kieSessionRule, _jsx(Tooltip, Object.assign({ content: i18n.drawer.settings.kieSessionRuleTooltip }, { children: _jsx(Icon, Object.assign({ className: "kie-scesim-editor-drawer-settings--info-icon", size: "sm", status: "info" }, { children: _jsx(HelpIcon, {}) })) }))] })), _jsx(TextInput, { className: "kie-scesim-editor-drawer-settings--text-input", onChange: (value) => onUpdateSettingField("dmoSession", value), placeholder: i18n.drawer.settings.kieSessionRulePlaceholder, type: "text", value: testScenarioSettings.kieSessionRule }), _jsxs(Title, Object.assign({ className: "kie-scesim-editor-drawer-settings--title", headingLevel: "h6" }, { children: [i18n.drawer.settings.ruleFlowGroup, _jsx(Tooltip, Object.assign({ content: i18n.drawer.settings.ruleFlowGroupTooltip }, { children: _jsx(Icon, Object.assign({ className: "kie-scesim-editor-drawer-settings--info-icon", size: "sm", status: "info" }, { children: _jsx(HelpIcon, {}) })) }))] })), _jsx(TextInput, { className: "kie-scesim-editor-drawer-settings--text-input", onChange: (value) => onUpdateSettingField("ruleFlowGroup", value), placeholder: i18n.drawer.settings.ruleFlowGroupPlaceholder, type: "text", value: testScenarioSettings.ruleFlowGroup }), _jsxs("div", Object.assign({ className: "kie-scesim-editor-drawer-settings--checkbox-group" }, { children: [_jsx("div", Object.assign({ className: "kie-scesim-editor-drawer-settings--checkbox" }, { children: _jsx(Checkbox, { id: "stateless-session", isChecked: testScenarioSettings.isStatelessSessionRule, label: i18n.drawer.settings.statelessSessionRule, onChange: (value) => onUpdateSettingField("stateless", value) }) })), _jsx(Tooltip, Object.assign({ content: i18n.drawer.settings.statelessSessionRuleTooltip }, { children: _jsx(Icon, Object.assign({ className: "kie-scesim-editor-drawer-settings--info-icon", size: "sm", status: "info" }, { children: _jsx(HelpIcon, {}) })) }))] }))] })), _jsxs("div", Object.assign({ className: "kie-scesim-editor-drawer-settings--checkbox-group" }, { children: [_jsx("div", Object.assign({ className: "kie-scesim-editor-drawer-settings--checkbox" }, { children: _jsx(Checkbox, { id: "skip-test", isChecked: testScenarioSettings.isTestSkipped, label: i18n.drawer.settings.testSkipped, onChange: (value) => onUpdateSettingField("skipFromBuild", value) }) })), _jsx(Tooltip, Object.assign({ content: i18n.drawer.settings.testSkippedTooltip }, { children: _jsx(Icon, Object.assign({ className: "kie-scesim-editor-drawer-settings--info-icon", size: "sm", status: "info" }, { children: _jsx(HelpIcon, {}) })) }))] }))] }));
}
export default TestScenarioDrawerSettingsPanel;
//# sourceMappingURL=TestScenarioDrawerSettingsPanel.js.map