import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Checkbox } from "@patternfly/react-core/dist/js/components/Checkbox";
import { EmptyState, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { FormSelect, FormSelectOption } from "@patternfly/react-core/dist/js/components/FormSelect";
import { HelpIcon } from "@patternfly/react-icons/dist/esm/icons/help-icon";
import { Icon } from "@patternfly/react-core/dist/js/components/Icon";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import AddIcon from "@patternfly/react-icons/dist/esm/icons/add-circle-o-icon";
import CubesIcon from "@patternfly/react-icons/dist/esm/icons/cubes-icon";
import { TestScenarioType } from "../TestScenarioEditor";
import { useTestScenarioEditorI18n } from "../i18n";
import "./TestScenarioCreationPanel.css";
function TestScenarioCreationPanel({ onCreateScesimButtonClicked, }) {
    const { i18n } = useTestScenarioEditorI18n();
    const assetsOption = [
        { value: "", label: i18n.creationPanel.assetsOption.noChoice, disabled: true },
        { value: TestScenarioType[TestScenarioType.DMN], label: i18n.creationPanel.assetsOption.dmn, disabled: false },
        { value: TestScenarioType[TestScenarioType.RULE], label: i18n.creationPanel.assetsOption.rule, disabled: false },
    ];
    const [assetType, setAssetType] = React.useState("");
    const [isAutoFillTableEnabled, setAutoFillTableEnabled] = React.useState(true);
    const [isStatelessSessionRule, setStatelessSessionRule] = React.useState(false);
    const [isTestSkipped, setTestSkipped] = React.useState(false);
    const [kieSessionRule, setKieSessionRule] = React.useState("");
    const [ruleFlowGroup, setRuleFlowGroup] = React.useState("");
    return (_jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(Title, Object.assign({ headingLevel: "h6", size: "md" }, { children: i18n.creationPanel.title })), _jsxs(Form, Object.assign({ isHorizontal: true, className: "kie-scesim-editor--creation-form" }, { children: [_jsx(FormGroup, Object.assign({ label: i18n.creationPanel.assetsGroup, isRequired: true }, { children: _jsx(FormSelect, Object.assign({ id: "asset-type-select", name: "asset-type-select", onChange: (value) => setAssetType(value), value: assetType }, { children: assetsOption.map((option, index) => (_jsx(FormSelectOption, { isDisabled: option.disabled, label: option.label, value: option.value }, index))) })) })), assetType === TestScenarioType[TestScenarioType.DMN] && (_jsxs(_Fragment, { children: [_jsx(FormGroup, Object.assign({ label: i18n.creationPanel.dmnGroup, isRequired: true }, { children: _jsx(FormSelect, Object.assign({ id: "dmn-select", name: "dmn-select", value: "", isDisabled: true }, { children: _jsx(FormSelectOption, { isDisabled: true, value: "", label: i18n.creationPanel.dmnNoChoice }, 0) })) })), _jsx(FormGroup, { children: _jsx(Checkbox, { id: "auto-fill-table-checkbox", isChecked: isAutoFillTableEnabled, label: _jsxs(_Fragment, { children: [_jsx("span", { children: i18n.creationPanel.autoFillTable }), _jsx(Tooltip, Object.assign({ content: i18n.creationPanel.autoFillTableTooltip }, { children: _jsx(Icon, Object.assign({ className: "kie-scesim-editor-creation-panel--info-icon", size: "sm", status: "info" }, { children: _jsx(HelpIcon, {}) })) }))] }), onChange: (value) => {
                                        setAutoFillTableEnabled(value);
                                    } }) })] })), assetType === TestScenarioType[TestScenarioType.RULE] && (_jsxs(_Fragment, { children: [_jsx(FormGroup, Object.assign({ label: i18n.creationPanel.kieSessionGroup }, { children: _jsx(TextInput, { onChange: (value) => setKieSessionRule(value), placeholder: "<" + i18n.creationPanel.optional + ">", type: "text", value: kieSessionRule }) })), _jsx(FormGroup, Object.assign({ label: i18n.creationPanel.kieAgendaGroup }, { children: _jsx(TextInput, { onChange: (value) => setRuleFlowGroup(value), placeholder: "<" + i18n.creationPanel.optional + ">", type: "text", value: ruleFlowGroup }) })), _jsx(FormGroup, { children: _jsx(Checkbox, { id: "stateless-session-checkbox", isChecked: isStatelessSessionRule, label: _jsxs(_Fragment, { children: [_jsx("span", { children: i18n.creationPanel.statelessSession }), _jsx(Tooltip, Object.assign({ content: i18n.drawer.settings.statelessSessionRuleTooltip }, { children: _jsx(Icon, Object.assign({ className: "kie-scesim-editor-creation-panel--info-icon", size: "sm", status: "info" }, { children: _jsx(HelpIcon, {}) })) }))] }), onChange: (value) => {
                                        setStatelessSessionRule(value);
                                    } }) })] })), _jsx(FormGroup, { children: _jsx(Checkbox, { id: "test-skipped-checkbox", isChecked: isTestSkipped, label: _jsxs(_Fragment, { children: [_jsx("span", { children: i18n.creationPanel.testSkip }), _jsx(Tooltip, Object.assign({ content: i18n.drawer.settings.testSkippedTooltip }, { children: _jsx(Icon, Object.assign({ className: "kie-scesim-editor-creation-panel--info-icon", size: "sm", status: "info" }, { children: _jsx(HelpIcon, {}) })) }))] }), onChange: (value) => {
                                setTestSkipped(value);
                            } }) })] })), _jsx(Button, Object.assign({ icon: _jsx(AddIcon, {}), isDisabled: assetType == "", onClick: () => onCreateScesimButtonClicked(assetType, isStatelessSessionRule, isTestSkipped, kieSessionRule, ruleFlowGroup), variant: "primary" }, { children: i18n.creationPanel.createButton }))] }));
}
export default TestScenarioCreationPanel;
//# sourceMappingURL=TestScenarioCreationPanel.js.map