var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import "@patternfly/react-core/dist/styles/base.css";
import * as React from "react";
import { useCallback, useEffect, useImperativeHandle, useMemo, useRef, useState } from "react";
import { I18nDictionariesProvider } from "@kie-tools-core/i18n/dist/react-components";
import { testScenarioEditorDictionaries, TestScenarioEditorI18nContext, testScenarioEditorI18nDefaults } from "./i18n";
import { getMarshaller } from "@kie-tools/scesim-marshaller";
import { Alert } from "@patternfly/react-core/dist/js/components/Alert";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Drawer, DrawerContent, DrawerContentBody } from "@patternfly/react-core/dist/js/components/Drawer";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Icon } from "@patternfly/react-core/dist/js/components/Icon";
import { Spinner } from "@patternfly/react-core/dist/js/components/Spinner";
import { Tabs, Tab, TabTitleIcon, TabTitleText } from "@patternfly/react-core/dist/js/components/Tabs";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import ErrorIcon from "@patternfly/react-icons/dist/esm/icons/error-circle-o-icon";
import TableIcon from "@patternfly/react-icons/dist/esm/icons/table-icon";
import HelpIcon from "@patternfly/react-icons/dist/esm/icons/help-icon";
import ErrorBoundary from "./reactExt/ErrorBoundary";
import TestScenarioDrawerPanel from "./drawer/TestScenarioDrawerPanel";
import TestScenarioSideBarMenu from "./sidebar/TestScenarioSideBarMenu";
import TestScenarioTable from "./table/TestScenarioTable";
import { useTestScenarioEditorI18n } from "./i18n";
import { EMPTY_ONE_EIGHT } from "./resources/EmptyScesimFile";
import "./TestScenarioEditor.css";
import TestScenarioCreationPanel from "./creation/TestScenarioCreationPanel";
const CURRENT_SUPPORTED_VERSION = "1.8";
export var TestScenarioEditorDock;
(function (TestScenarioEditorDock) {
    TestScenarioEditorDock[TestScenarioEditorDock["CHEATSHEET"] = 0] = "CHEATSHEET";
    TestScenarioEditorDock[TestScenarioEditorDock["DATA_OBJECT"] = 1] = "DATA_OBJECT";
    TestScenarioEditorDock[TestScenarioEditorDock["SETTINGS"] = 2] = "SETTINGS";
})(TestScenarioEditorDock || (TestScenarioEditorDock = {}));
var TestScenarioEditorTab;
(function (TestScenarioEditorTab) {
    TestScenarioEditorTab[TestScenarioEditorTab["EDITOR"] = 0] = "EDITOR";
    TestScenarioEditorTab[TestScenarioEditorTab["BACKGROUND"] = 1] = "BACKGROUND";
})(TestScenarioEditorTab || (TestScenarioEditorTab = {}));
var TestScenarioFileStatus;
(function (TestScenarioFileStatus) {
    TestScenarioFileStatus[TestScenarioFileStatus["EMPTY"] = 0] = "EMPTY";
    TestScenarioFileStatus[TestScenarioFileStatus["ERROR"] = 1] = "ERROR";
    TestScenarioFileStatus[TestScenarioFileStatus["NEW"] = 2] = "NEW";
    TestScenarioFileStatus[TestScenarioFileStatus["UNSUPPORTED"] = 3] = "UNSUPPORTED";
    TestScenarioFileStatus[TestScenarioFileStatus["VALID"] = 4] = "VALID";
})(TestScenarioFileStatus || (TestScenarioFileStatus = {}));
export var TestScenarioType;
(function (TestScenarioType) {
    TestScenarioType[TestScenarioType["DMN"] = 0] = "DMN";
    TestScenarioType[TestScenarioType["RULE"] = 1] = "RULE";
})(TestScenarioType || (TestScenarioType = {}));
function TestScenarioMainPanel({ fileName, scesimModel, updateSettingField, updateTestScenarioModel, }) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    const { i18n } = useTestScenarioEditorI18n();
    const [alert, setAlert] = useState({ enabled: false, variant: "info" });
    const [dataObjects, setDataObjects] = useState([]);
    const [dockPanel, setDockPanel] = useState({ isOpen: true, selected: TestScenarioEditorDock.DATA_OBJECT });
    const [selectedColumnMetadata, setSelectedColumnMetaData] = useState(null);
    const [tab, setTab] = useState(TestScenarioEditorTab.EDITOR);
    const scenarioTableScrollableElementRef = useRef(null);
    const backgroundTableScrollableElementRef = useRef(null);
    const onTabChanged = useCallback((_event, tab) => {
        setSelectedColumnMetaData(null);
        setTab(tab);
    }, []);
    const closeDockPanel = useCallback(() => {
        setDockPanel((prev) => {
            return Object.assign(Object.assign({}, prev), { isOpen: false });
        });
    }, []);
    const openDockPanel = useCallback((selected) => {
        setDockPanel({ isOpen: true, selected: selected });
    }, []);
    useEffect(() => {
        setDockPanel({ isOpen: true, selected: TestScenarioEditorDock.DATA_OBJECT });
        setSelectedColumnMetaData(null);
        setTab(TestScenarioEditorTab.EDITOR);
    }, [fileName]);
    useEffect(() => {
        var _a, _b;
        const factsMappings = (_a = scesimModel.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping) !== null && _a !== void 0 ? _a : [];
        const dataObjects = [];
        for (let i = 2; i < factsMappings.length; i++) {
            if (factsMappings[i].className.__$$text === "java.lang.Void") {
                continue;
            }
            const factID = factsMappings[i].expressionElements.ExpressionElement[0].step.__$$text;
            const dataObject = dataObjects.find((value) => value.id === factID);
            const isSimpleTypeFact = factsMappings[i].expressionElements.ExpressionElement.length == 1;
            const propertyID = isSimpleTypeFact
                ? factsMappings[i].expressionElements.ExpressionElement[0].step.__$$text.concat(".")
                : factsMappings[i]
                    .expressionElements.ExpressionElement.map((expressionElement) => expressionElement.step.__$$text)
                    .join(".");
            const propertyName = isSimpleTypeFact
                ? "value"
                : factsMappings[i].expressionElements.ExpressionElement.slice(-1)[0].step.__$$text;
            if (dataObject) {
                if (!((_b = dataObject.children) === null || _b === void 0 ? void 0 : _b.some((value) => value.id === propertyID))) {
                    dataObject.children.push({
                        id: propertyID,
                        customBadgeContent: factsMappings[i].className.__$$text,
                        isSimpleTypeFact: isSimpleTypeFact,
                        name: propertyName,
                    });
                }
            }
            else {
                dataObjects.push({
                    id: factID,
                    name: factsMappings[i].factAlias.__$$text,
                    customBadgeContent: factsMappings[i].factIdentifier.className.__$$text,
                    children: [
                        {
                            id: propertyID,
                            name: propertyName,
                            customBadgeContent: factsMappings[i].className.__$$text,
                        },
                    ],
                });
            }
        }
        setDataObjects(dataObjects);
    }, [scesimModel.ScenarioSimulationModel.settings.type]);
    useEffect(() => {
        const assetType = scesimModel.ScenarioSimulationModel.settings.type.__$$text;
        let alertEnabled = false;
        let alertMessage = "";
        let alertVariant = "danger";
        if (dataObjects.length > 0) {
            alertMessage =
                assetType === TestScenarioType[TestScenarioType.DMN]
                    ? i18n.alerts.dmnDataRetrievedFromScesim
                    : i18n.alerts.ruleDataRetrievedFromScesim;
            alertEnabled = true;
        }
        else {
            alertMessage =
                assetType === TestScenarioType[TestScenarioType.DMN]
                    ? i18n.alerts.dmnDataNotAvailable
                    : i18n.alerts.ruleDataNotAvailable;
            alertVariant = assetType === TestScenarioType[TestScenarioType.DMN] ? "warning" : "danger";
            alertEnabled = true;
        }
        setAlert({ enabled: alertEnabled, message: alertMessage, variant: alertVariant });
    }, [dataObjects, i18n, scesimModel.ScenarioSimulationModel.settings.type]);
    return (_jsxs(_Fragment, { children: [_jsx("div", Object.assign({ className: "kie-scesim-editor--content" }, { children: _jsx(Drawer, Object.assign({ isExpanded: dockPanel.isOpen, isInline: true, position: "right" }, { children: _jsx(DrawerContent, Object.assign({ panelContent: _jsx(TestScenarioDrawerPanel, { dataObjects: dataObjects, fileName: fileName, onDrawerClose: closeDockPanel, onUpdateSettingField: updateSettingField, scesimModel: scesimModel, selectedColumnMetaData: selectedColumnMetadata, selectedDock: dockPanel.selected, testScenarioSettings: {
                                assetType: scesimModel.ScenarioSimulationModel.settings.type.__$$text,
                                dmnName: (_a = scesimModel.ScenarioSimulationModel.settings.dmnName) === null || _a === void 0 ? void 0 : _a.__$$text,
                                dmnNamespace: (_b = scesimModel.ScenarioSimulationModel.settings.dmnNamespace) === null || _b === void 0 ? void 0 : _b.__$$text,
                                isStatelessSessionRule: (_d = (_c = scesimModel.ScenarioSimulationModel.settings.stateless) === null || _c === void 0 ? void 0 : _c.__$$text) !== null && _d !== void 0 ? _d : false,
                                isTestSkipped: (_f = (_e = scesimModel.ScenarioSimulationModel.settings.skipFromBuild) === null || _e === void 0 ? void 0 : _e.__$$text) !== null && _f !== void 0 ? _f : false,
                                kieSessionRule: (_g = scesimModel.ScenarioSimulationModel.settings.dmoSession) === null || _g === void 0 ? void 0 : _g.__$$text,
                                ruleFlowGroup: (_h = scesimModel.ScenarioSimulationModel.settings.ruleFlowGroup) === null || _h === void 0 ? void 0 : _h.__$$text,
                            }, updateSelectedColumnMetaData: setSelectedColumnMetaData, updateTestScenarioModel: updateTestScenarioModel }) }, { children: _jsxs(DrawerContentBody, { children: [alert.enabled && (_jsx("div", Object.assign({ className: "kie-scesim-editor--content-alert" }, { children: _jsx(Alert, { variant: alert.variant, title: alert.message }) }))), _jsx("div", Object.assign({ className: "kie-scesim-editor--content-tabs" }, { children: _jsxs(Tabs, Object.assign({ isFilled: true, activeKey: tab, onSelect: onTabChanged, role: "region" }, { children: [_jsx(Tab, Object.assign({ eventKey: TestScenarioEditorTab.EDITOR, title: _jsxs(_Fragment, { children: [_jsx(TabTitleIcon, { children: _jsx(TableIcon, {}) }), _jsx(TabTitleText, { children: i18n.tab.scenarioTabTitle }), _jsx(Tooltip, Object.assign({ content: i18n.tab.scenarioTabInfo }, { children: _jsx(Icon, Object.assign({ size: "sm", status: "info" }, { children: _jsx(HelpIcon, {}) })) }))] }) }, { children: _jsx("div", Object.assign({ className: "kie-scesim-editor--scenario-table-container", ref: scenarioTableScrollableElementRef }, { children: _jsx(TestScenarioTable, { assetType: scesimModel.ScenarioSimulationModel.settings.type.__$$text, tableData: scesimModel.ScenarioSimulationModel.simulation, scrollableParentRef: scenarioTableScrollableElementRef, updateSelectedColumnMetaData: setSelectedColumnMetaData, updateTestScenarioModel: updateTestScenarioModel }) })) })), _jsx(Tab, Object.assign({ eventKey: TestScenarioEditorTab.BACKGROUND, title: _jsxs(_Fragment, { children: [_jsx(TabTitleIcon, { children: _jsx(TableIcon, {}) }), _jsx(TabTitleText, { children: i18n.tab.backgroundTabTitle }), _jsx(Tooltip, Object.assign({ content: i18n.tab.backgroundTabInfo }, { children: _jsx(Icon, Object.assign({ size: "sm", status: "info" }, { children: _jsx(HelpIcon, {}) })) }))] }) }, { children: _jsx("div", Object.assign({ className: "kie-scesim-editor--background-table-container", ref: backgroundTableScrollableElementRef }, { children: _jsx(TestScenarioTable, { assetType: scesimModel.ScenarioSimulationModel.settings.type.__$$text, tableData: scesimModel.ScenarioSimulationModel.background, scrollableParentRef: backgroundTableScrollableElementRef, updateSelectedColumnMetaData: setSelectedColumnMetaData, updateTestScenarioModel: updateTestScenarioModel }) })) }))] })) }))] }) })) })) })), _jsx(TestScenarioSideBarMenu, { selectedSideBarMenuItem: dockPanel, onSideBarButtonClicked: openDockPanel })] }));
}
function TestScenarioParserErrorPanel({ parserErrorTitle, parserErrorMessage, }) {
    return (_jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: ErrorIcon }), _jsx(Title, Object.assign({ headingLevel: "h4", size: "lg" }, { children: parserErrorTitle })), _jsx(EmptyStateBody, { children: parserErrorMessage })] }));
}
const TestScenarioEditorInternal = ({ forwardRef }) => {
    const [scesimFile, setScesimFile] = useState({ content: "", path: "" });
    const marshaller = useMemo(() => getMarshaller(scesimFile.content.trim()), [scesimFile]);
    const scesimLoaded = useMemo(() => marshaller.parser.parse(), [marshaller.parser]);
    const [scesimModel, setScesimModel] = useState(scesimLoaded);
    const scesimFileStatus = useMemo(() => {
        var _a;
        if (scesimModel.ScenarioSimulationModel) {
            const parserErrorField = "parsererror";
            if (scesimModel.ScenarioSimulationModel[parserErrorField]) {
                return TestScenarioFileStatus.ERROR;
            }
            if (scesimModel.ScenarioSimulationModel["@_version"] != CURRENT_SUPPORTED_VERSION) {
                return TestScenarioFileStatus.UNSUPPORTED;
            }
            else if ((_a = scesimModel.ScenarioSimulationModel["settings"]) === null || _a === void 0 ? void 0 : _a["type"]) {
                return TestScenarioFileStatus.VALID;
            }
            else {
                return TestScenarioFileStatus.NEW;
            }
        }
        else {
            return TestScenarioFileStatus.EMPTY;
        }
    }, [scesimModel]);
    useEffect(() => {
        console.debug("SCESIM Model updated");
        console.debug(scesimLoaded);
        setScesimModel(scesimLoaded);
    }, [scesimLoaded]);
    useImperativeHandle(forwardRef, () => ({
        getContent: () => marshaller.builder.build(scesimModel),
        getDiagramSvg: () => __awaiter(void 0, void 0, void 0, function* () { return undefined; }),
        setContent: (normalizedPosixPathRelativeToTheWorkspaceRoot, content) => {
            console.debug("SCESIM setContent called");
            console.debug("=== FILE CONTENT ===");
            console.debug(content ? content : "EMPTY FILE");
            console.debug("=== END FILE CONTENT ===");
            setScesimFile({ content: content || EMPTY_ONE_EIGHT, path: normalizedPosixPathRelativeToTheWorkspaceRoot });
        },
    }), [marshaller.builder, scesimModel]);
    const setInitialSettings = useCallback((assetType, isStatelessSessionRule, isTestSkipped, kieSessionRule, ruleFlowGroup) => setScesimModel((prevState) => ({
        ScenarioSimulationModel: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel), { settings: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel.settings), { dmnFilePath: assetType === TestScenarioType[TestScenarioType.DMN] ? { __$$text: "./MockedDMNName.dmn" } : undefined, dmoSession: assetType === TestScenarioType[TestScenarioType.RULE] && kieSessionRule
                    ? { __$$text: kieSessionRule }
                    : undefined, ruleFlowGroup: assetType === TestScenarioType[TestScenarioType.RULE] && ruleFlowGroup
                    ? { __$$text: ruleFlowGroup }
                    : undefined, skipFromBuild: { __$$text: isTestSkipped }, stateless: assetType === TestScenarioType[TestScenarioType.RULE] ? { __$$text: isStatelessSessionRule } : undefined, type: { __$$text: assetType } }) }),
    })), [setScesimModel]);
    const updateSettingsField = useCallback((fieldName, value) => setScesimModel((prevState) => ({
        ScenarioSimulationModel: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel), { ["settings"]: Object.assign(Object.assign({}, prevState.ScenarioSimulationModel["settings"]), { [fieldName]: { __$$text: value } }) }),
    })), [setScesimModel]);
    return (_jsx(_Fragment, { children: (() => {
            switch (scesimFileStatus) {
                case TestScenarioFileStatus.EMPTY:
                    return (_jsx(Bullseye, { children: _jsx(Spinner, { "aria-label": "SCESIM Data loading .." }) }));
                case TestScenarioFileStatus.ERROR:
                    return (_jsx(TestScenarioParserErrorPanel, { parserErrorTitle: "File parsing error", parserErrorMessage: "Impossibile to correctly parse the provided scesim file. Most likely, the XML structure of the file " +
                            "is invalid." }));
                case TestScenarioFileStatus.NEW:
                    return _jsx(TestScenarioCreationPanel, { onCreateScesimButtonClicked: setInitialSettings });
                case TestScenarioFileStatus.UNSUPPORTED:
                    return (_jsx(TestScenarioParserErrorPanel, { parserErrorTitle: "This file holds a Test Scenario asset version (" +
                            scesimModel.ScenarioSimulationModel["@_version"] +
                            ") not supported", parserErrorMessage: "Most likely, this file has been generated with a very old Business Central version (< 7.30.0.Final). " +
                            "Please update your Business Central instance and download again this scesim file, it will be automatically updated to the supported version (" +
                            CURRENT_SUPPORTED_VERSION +
                            ")." }));
                case TestScenarioFileStatus.VALID:
                    return (_jsx(TestScenarioMainPanel, { fileName: scesimFile.path, scesimModel: scesimModel, updateTestScenarioModel: setScesimModel, updateSettingField: updateSettingsField }));
            }
        })() }));
};
export const TestScenarioEditor = React.forwardRef((props, ref) => {
    const [scesimFileParsingError, setScesimFileParsingError] = useState(null);
    return (_jsx(I18nDictionariesProvider, Object.assign({ defaults: testScenarioEditorI18nDefaults, dictionaries: testScenarioEditorDictionaries, initialLocale: navigator.language, ctx: TestScenarioEditorI18nContext }, { children: _jsx(ErrorBoundary, Object.assign({ error: _jsx(TestScenarioParserErrorPanel, { parserErrorTitle: "File parsing error", parserErrorMessage: "Impossibile to correctly parse the provided scesim file. Cause: " + (scesimFileParsingError === null || scesimFileParsingError === void 0 ? void 0 : scesimFileParsingError.message) }), setError: setScesimFileParsingError }, { children: _jsx(TestScenarioEditorInternal, Object.assign({ forwardRef: ref }, props)) })) })));
});
//# sourceMappingURL=TestScenarioEditor.js.map