import { TextDocument } from "vscode-languageserver-textdocument";
import { CodeLens, Position } from "vscode-languageserver-types";
import { EditorLanguageServiceCommandExecution, EditorLanguageServiceCommandTypes } from "../api";
import { ELsCodeCompletionStrategy, ELsJsonPath, ELsNode, ELsNodeType } from "./types";
export declare type EditorLanguageServiceCodeLensesFunctionsArgs<CommandTypes = never> = {
    document: TextDocument;
    content: string;
    rootNode: ELsNode;
    codeCompletionStrategy: ELsCodeCompletionStrategy<CommandTypes>;
};
export declare const createCodeLenses: (args: {
    document: TextDocument;
    rootNode: ELsNode;
    jsonPath: ELsJsonPath;
    commandDelegates: (args: {
        position: Position;
        node: ELsNode;
    }) => ({
        title: string;
    } & EditorLanguageServiceCommandExecution<any, any>)[];
    positionLensAt: "begin" | "end";
}) => CodeLens[];
export declare const createOpenCompletionItemsCodeLenses: (args: {
    jsonPath: string[];
    title: string;
    nodeType: ELsNodeType;
    commandName?: EditorLanguageServiceCommandTypes;
} & EditorLanguageServiceCodeLensesFunctionsArgs<EditorLanguageServiceCommandTypes>) => CodeLens[];
export declare const createNewFileCodeLens: (title: string) => CodeLens[];
export declare type EditorLanguageServiceCodeLenses = {
    [name: string]: (args: EditorLanguageServiceCodeLensesFunctionsArgs) => CodeLens[];
    createNewFile: () => CodeLens[];
};
//# sourceMappingURL=EditorLanguageServiceCodeLenses.d.ts.map