import { JSONSchema } from "vscode-json-languageservice";
import { TextDocument } from "vscode-languageserver-textdocument";
import { CodeLens, CompletionItem, Diagnostic, Position, Range } from "vscode-languageserver-types";
import { FileLanguage } from "../api";
import { EditorLanguageServiceCodeCompletionFunctionsArgs, ELsCompletionsMap } from "./EditorLanguageServiceCodeCompletion";
import { EditorLanguageServiceCodeLenses } from "./EditorLanguageServiceCodeLenses";
import { RefValidationMap } from "./refValidation";
import { ELsCodeCompletionStrategy, ELsJsonPath, ELsNode, IEditorLanguageService } from "./types";
export declare type EditorLanguageServiceArgs = {
    fs: {};
    lang: {
        fileLanguage: FileLanguage;
        fileMatch: string[];
    };
};
export declare class EditorLanguageService implements IEditorLanguageService {
    private readonly args;
    constructor(args: EditorLanguageServiceArgs);
    getCompletionItems(args: {
        content: string;
        uri: string;
        cursorPosition: Position;
        cursorWordRange: Range;
        rootNode: ELsNode | undefined;
        codeCompletionStrategy: ELsCodeCompletionStrategy;
        completions: ELsCompletionsMap<EditorLanguageServiceCodeCompletionFunctionsArgs>;
        extraCompletionFunctionsArgs?: {};
    }): Promise<CompletionItem[]>;
    getDiagnostics(args: {
        content: string;
        uriPath: string;
        rootNode: ELsNode | undefined;
        getSchemaDiagnostics?: (args: {
            textDocument: TextDocument;
            fileMatch: string[];
        }) => Promise<Diagnostic[]>;
        validationMap?: RefValidationMap;
    }): Promise<Diagnostic[]>;
    getCodeLenses(args: {
        content: string;
        uri: string;
        rootNode: ELsNode | undefined;
        codeCompletionStrategy: ELsCodeCompletionStrategy;
        codeLenses: EditorLanguageServiceCodeLenses;
        extraCodeLensesFunctionsArgs?: {};
    }): Promise<CodeLens[]>;
    getSchemaDiagnostics(args: {
        textDocument: TextDocument;
        fileMatch: string[];
        jsonSchema: JSONSchema;
    }): Promise<Diagnostic[]>;
    dispose(): void;
}
export declare function findNodeAtLocation(root: ELsNode, path: ELsJsonPath): ELsNode | undefined;
export declare function findNodeAtOffset(root: ELsNode, offset: number, includeRightBound?: boolean): ELsNode | undefined;
export declare function getNodePath(node: ELsNode): ELsJsonPath;
export declare const positions_equals: (a: Position | null, b: Position | null) => boolean;
//# sourceMappingURL=EditorLanguageService.d.ts.map