import * as React from "react";
import { ApiDefinition, MessageBusClientApi } from "@kie-tools-core/envelope-bus/dist/api";
import { KogitoEditorChannelApi } from "./KogitoEditorChannelApi";
import { I18nService } from "@kie-tools-core/i18n/dist/envelope";
import { OperatingSystem } from "@kie-tools-core/operating-system";
import { KeyboardShortcutsService } from "@kie-tools-core/keyboard-shortcuts/dist/envelope/KeyboardShortcutsService";
import { EditorTheme } from "./EditorTheme";
export interface KogitoEditorEnvelopeContextType<ChannelApi extends KogitoEditorChannelApi & ApiDefinition<ChannelApi>> {
    channelApi: MessageBusClientApi<ChannelApi>;
    operatingSystem?: OperatingSystem;
    services: {
        keyboardShortcuts: KeyboardShortcutsService;
        i18n: I18nService;
    };
    supportedThemes: EditorTheme[];
}
export declare const KogitoEditorEnvelopeContext: React.Context<KogitoEditorEnvelopeContextType<any>>;
export declare function useKogitoEditorEnvelopeContext<ChannelApi extends KogitoEditorChannelApi & ApiDefinition<ChannelApi> = KogitoEditorChannelApi>(): KogitoEditorEnvelopeContextType<ChannelApi>;
//# sourceMappingURL=KogitoEditorEnvelopeContext.d.ts.map