import { EditorContent, EditorTheme, KogitoEditorChannelApi, StateControlCommand } from "@kie-tools-core/editor/dist/api";
import { MessageBusClientApi, SharedValueProvider } from "@kie-tools-core/envelope-bus/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
import { WorkspaceEdit, ResourceContent, ResourceContentRequest, ResourceListRequest, ResourcesList } from "@kie-tools-core/workspace/dist/api";
import { ServerlessWorkflowDiagramEditorEnvelopeApi } from "@kie-tools/serverless-workflow-diagram-editor-envelope/dist/api";
import { SwfServiceCatalogChannelApi, SwfServiceCatalogService, SwfServiceRegistriesSettings } from "@kie-tools/serverless-workflow-service-catalog/dist/api";
import { ServerlessWorkflowTextEditorChannelApi } from "@kie-tools/serverless-workflow-text-editor/dist/api";
import { CodeLens, CompletionItem, Position, Range } from "vscode-languageserver-types";
export declare class ServerlessWorkflowTextEditorChannelApiImpl implements ServerlessWorkflowTextEditorChannelApi {
    private readonly args;
    constructor(args: {
        defaultApiImpl: KogitoEditorChannelApi;
        channelApi: MessageBusClientApi<ServerlessWorkflowTextEditorChannelApi>;
        swfServiceCatalogApiImpl?: SwfServiceCatalogChannelApi;
        diagramEditorEnvelopeApi?: MessageBusClientApi<ServerlessWorkflowDiagramEditorEnvelopeApi>;
    });
    kogitoEditor_contentRequest(): Promise<EditorContent>;
    kogitoEditor_ready(): void;
    kogitoEditor_setContentError(content: EditorContent): void;
    kogitoEditor_stateControlCommandUpdate(command: StateControlCommand): void;
    kogitoI18n_getLocale(): Promise<string>;
    kogitoNotifications_createNotification(notification: Notification): void;
    kogitoNotifications_removeNotifications(normalizedPosixPathRelativeToTheWorkspaceRoot: string): void;
    kogitoNotifications_setNotifications(normalizedPosixPathRelativeToTheWorkspaceRoot: string, notifications: Notification[]): void;
    kogitoWorkspace_newEdit(edit: WorkspaceEdit): void;
    kogitoWorkspace_openFile(normalizedPosixPathRelativeToTheWorkspaceRoot: string): void;
    kogitoWorkspace_resourceContentRequest(request: ResourceContentRequest): Promise<ResourceContent | undefined>;
    kogitoWorkspace_resourceListRequest(request: ResourceListRequest): Promise<ResourcesList>;
    kogitoEditor_theme(): SharedValueProvider<EditorTheme>;
    kogitoSwfServiceCatalog_serviceRegistriesSettings(): SharedValueProvider<SwfServiceRegistriesSettings>;
    kogitoSwfServiceCatalog_services(): SharedValueProvider<SwfServiceCatalogService[]>;
    kogitoSwfServiceCatalog_refresh(): void;
    kogitoSwfServiceCatalog_importFunctionFromCompletionItem(args: {
        containingService: SwfServiceCatalogService;
        documentUri: string;
    }): void;
    kogitoSwfServiceCatalog_importEventFromCompletionItem(args: {
        containingService: SwfServiceCatalogService;
        documentUri: string;
    }): void;
    kogitoSwfServiceCatalog_logInServiceRegistries(): void;
    kogitoSwfLanguageService__getCompletionItems(args: {
        content: string;
        uri: string;
        cursorPosition: Position;
        cursorWordRange: Range;
    }): Promise<CompletionItem[]>;
    kogitoSwfLanguageService__getCodeLenses(args: {
        uri: string;
        content: string;
    }): Promise<CodeLens[]>;
    kogitoSwfServiceCatalog_setupServiceRegistriesSettings(): void;
    kogitoSwfTextEditor__onSelectionChanged(args: {
        nodeName: string;
    }): void;
}
//# sourceMappingURL=ServerlessWorkflowTextEditorChannelApiImpl.d.ts.map