import React, { useState } from "react";
import { DataList, DataListItem, DataListCell } from "@patternfly/react-core/dist/js/components/DataList";
import { Spinner } from "@patternfly/react-core/dist/js/components/Spinner";
import { DropdownItem, Dropdown, DropdownToggle, DropdownToggleAction, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { componentOuiaProps } from "../../ouiaTools";
import "../styles.css";
import { CheckIcon } from "@patternfly/react-icons/dist/js/icons/check-icon";
export const LoadMore = ({ offset, setOffset, getMoreItems, pageSize, isLoadingMore, setLoadMoreClicked, ouiaId, ouiaSafe, }) => {
    const [isOpen, setIsOpen] = useState(false);
    const [loadMoreValue, setLoadMoreValue] = useState(10);
    const loadMore = (newPageSize) => {
        setLoadMoreClicked && setLoadMoreClicked(true);
        const newOffset = offset + pageSize;
        setOffset(newOffset);
        getMoreItems(newOffset, newPageSize);
    };
    const onToggle = (isDropdownOpen) => {
        setIsOpen(isDropdownOpen);
    };
    const onSelect = (event) => {
        const selectedValue = parseInt(event.currentTarget.id, 10);
        setLoadMoreValue(selectedValue);
    };
    const dropdownItem = (count) => {
        return (React.createElement(DropdownItem, { key: "loadmore" + count, component: "button", id: count.toString() },
            React.createElement(Split, { hasGutter: true },
                React.createElement(SplitItem, null,
                    "Load ",
                    count,
                    " more"),
                loadMoreValue === count && (React.createElement(SplitItem, null,
                    React.createElement(CheckIcon, { size: "sm", color: "var(--pf-global--info-color--100)" }))))));
    };
    return (React.createElement(DataList, Object.assign({ "aria-label": "Simple data list example" }, componentOuiaProps(ouiaId, "load-more", ouiaSafe ? ouiaSafe : !isLoadingMore)),
        React.createElement(DataListItem, { "aria-labelledby": "kie-datalist-item" },
            React.createElement(DataListCell, { className: "kogito-components-common__load-more" },
                React.createElement("div", { className: "pf-u-float-right pf-u-mr-md" },
                    React.createElement(Dropdown, { onSelect: onSelect, direction: "up", toggle: React.createElement(DropdownToggle, { id: `toggle-id`, onToggle: onToggle, splitButtonItems: [
                                React.createElement(DropdownToggleAction, { key: `toggle-id-${ouiaId}`, onClick: () => {
                                        loadMore(loadMoreValue);
                                        setIsOpen(false);
                                    } }, isLoadingMore ? (React.createElement(React.Fragment, null,
                                    "Loading...",
                                    React.createElement(Spinner, { size: "md", className: "kogito-components-common__load-more-spinner" }),
                                    " ")) : (`Load ${loadMoreValue} more`)),
                            ] }), isOpen: isOpen, dropdownItems: [dropdownItem(10), dropdownItem(20), dropdownItem(50), dropdownItem(100)] }))))));
};
//# sourceMappingURL=LoadMore.js.map