import { Card, CardBody, CardHeader, CardHeaderMain, CardTitle } from "@patternfly/react-core/dist/js/components/Card";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Brand } from "@patternfly/react-core/dist/js/components/Brand";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import React from "react";
import kogitoLogo from "../../static/kogito.png";
import { componentOuiaProps } from "../../ouiaTools";
export const KeycloakUnavailablePage = ({ ouiaId, ouiaSafe }) => {
    return (React.createElement("div", Object.assign({ style: {
            display: "flex",
            justifyContent: "center",
            paddingTop: "5%",
            background: "#868686",
            height: "100%",
        } }, componentOuiaProps(ouiaId, "server-unavailable", ouiaSafe)),
        " ",
        React.createElement(Card, { style: {
                maxHeight: "300px",
            } },
            React.createElement(CardHeader, null,
                React.createElement(CardHeaderMain, null,
                    React.createElement(Brand, { src: kogitoLogo, alt: "Kogito keycloak", style: { height: "30px" } }))),
            React.createElement(CardBody, { isFilled: false }),
            React.createElement(CardTitle, null, "Error:503 - Server unavailable"),
            React.createElement(CardBody, { isFilled: false }),
            React.createElement(CardBody, null, "Sorry.. the keycloak server seems to be down"),
            React.createElement(CardBody, { isFilled: false }),
            React.createElement(Bullseye, null,
                React.createElement("span", null,
                    "Please contact administrator or",
                    " ",
                    React.createElement(Button, { variant: "link", onClick: () => window.location.reload(), isInline: true }, "click here to retry"))),
            React.createElement(CardBody, { isFilled: false }))));
};
//# sourceMappingURL=KeycloakUnavailablePage.js.map