import React from "react";
import { AboutModal } from "@patternfly/react-core/dist/js/components/AboutModal";
import { TextContent, Text, TextList, TextListItem } from "@patternfly/react-core/dist/js/components/Text";
import "../styles.css";
import aboutPageBackground from "../../static/kogitoAbout.png";
import { componentOuiaProps } from "../../ouiaTools";
import { useBrandContext } from "../../contexts/BrandContext/BrandContext";
const AboutModalBox = ({ isOpenProp, handleModalToggleProp, ouiaId, ouiaSafe }) => {
    const dataIndexURL = window.DATA_INDEX_ENDPOINT || process.env.KOGITO_DATAINDEX_HTTP_URL;
    const appName = window.KOGITO_APP_NAME || process.env.KOGITO_APP_NAME;
    const appVersion = window.KOGITO_APP_VERSION || process.env.KOGITO_APP_VERSION;
    const brandContext = useBrandContext();
    return (React.createElement(AboutModal, Object.assign({ isOpen: isOpenProp, onClose: handleModalToggleProp, trademark: `${appName} is part of Kogito, an open source software released under the Apache Software License 2.0`, brandImageSrc: brandContext.imageSrc, brandImageAlt: brandContext.altText, className: "kogito-consoles-common--aboutModalBox", backgroundImageSrc: aboutPageBackground }, componentOuiaProps(ouiaId, "AboutModalBox", ouiaSafe)),
        React.createElement(TextContent, null,
            React.createElement(Text, { component: "h5" }),
            React.createElement(TextList, { component: "dl" },
                React.createElement(TextListItem, { component: "dt" }, "Version: "),
                React.createElement(TextListItem, { component: "dd" }, appVersion),
                React.createElement(TextListItem, { component: "dt" }, "License information: "),
                React.createElement(TextListItem, { component: "dd" },
                    React.createElement("a", { href: "https://github.com/apache/incubator-kie-kogito-runtimes/blob/main/LICENSE", target: "_blank", rel: "noreferrer" }, "https://github.com/apache/incubator-kie-kogito-runtimes/blob/main/LICENSE")),
                React.createElement(TextListItem, { component: "dt" }, "Report a bug: "),
                React.createElement(TextListItem, { component: "dd" },
                    React.createElement("a", { href: "https://issues.redhat.com/projects/KOGITO", target: "_blank", rel: "noreferrer" }, "https://issues.redhat.com/projects/KOGITO")),
                React.createElement(TextListItem, { component: "dt" }, "Get involved/help/docs: "),
                React.createElement(TextListItem, { component: "dd" },
                    React.createElement("a", { href: "https://docs.jboss.org/kogito/release/latest/html_single/", target: "_blank", rel: "noreferrer" }, "https://docs.jboss.org/kogito/release/latest/html_single/")),
                React.createElement(TextListItem, { component: "dt" }, "Kogito URL: "),
                React.createElement(TextListItem, { component: "dd" },
                    React.createElement("a", { href: "https://kogito.kie.org", target: "_blank", rel: "noreferrer" }, "https://kogito.kie.org")),
                React.createElement(TextListItem, { component: "dt" }, "Data-Index URL: "),
                React.createElement(TextListItem, { component: "dd" },
                    dataIndexURL,
                    " ")))));
};
export default AboutModalBox;
//# sourceMappingURL=AboutModalBox.js.map