import { AutoGenerationErrorFormStatus, EmptyFormStatus, FormStatus, ValidatorErrorFormStatus } from "./FormStatus";
import { ErrorBoundary } from "@kie-tools/dmn-runner/dist/ErrorBoundary";
import AutoForm from "@kie-tools/uniforms-patternfly/dist/esm/AutoForm";
import * as React from "react";
export function FormBase(props) {
    return (React.createElement(React.Fragment, null,
        props.formStatus === FormStatus.VALIDATOR_ERROR && React.createElement(ValidatorErrorFormStatus, { i18n: props.i18n }),
        props.formStatus === FormStatus.AUTO_GENERATION_ERROR && (React.createElement(AutoGenerationErrorFormStatus, { notificationsPanel: props.notificationsPanel, i18n: props.i18n, openValidationTab: () => { var _a; return (_a = props.openValidationTab) === null || _a === void 0 ? void 0 : _a.call(props); } })),
        props.formStatus === FormStatus.EMPTY && React.createElement(EmptyFormStatus, { i18n: props.i18n }),
        props.formStatus === FormStatus.WITHOUT_ERROR && (React.createElement("div", { "data-testid": "form-base" },
            React.createElement(ErrorBoundary, { ref: props.errorBoundaryRef, setHasError: props.setFormError, error: React.createElement(AutoGenerationErrorFormStatus, { notificationsPanel: props.notificationsPanel, i18n: props.i18n, openValidationTab: () => { var _a; return (_a = props.openValidationTab) === null || _a === void 0 ? void 0 : _a.call(props); } }) },
                React.createElement(AutoForm, { id: props.id, model: props.formModel, ref: (node) => props.setFormRef(node), showInlineError: props.showInlineError, autosave: props.autoSave, autosaveDelay: props.autoSaveDelay, schema: props.jsonSchemaBridge, placeholder: props.placeholder, onSubmit: props.onSubmit, onValidate: props.onValidate, errorsField: props.errorsField, submitField: props.submitField, validate: "onSubmit" }, props.children))))));
}
//# sourceMappingURL=FormBase.js.map