import * as React from "react";
import { connectField } from "uniforms";
import AutoField from "./AutoField";
import ListDelField from "./ListDelField";
function ListItemField({ children = React.createElement(AutoField, { label: null, name: "" }) }) {
    return (React.createElement("div", { "data-testid": "list-item-field", style: {
            marginBottom: "1rem",
            display: "flex",
            justifyContent: "space-between",
        } },
        React.createElement("div", { style: { width: "100%", marginRight: "10px" } }, children),
        React.createElement("div", null,
            React.createElement(ListDelField, { name: "" }))));
}
export default connectField(ListItemField, {
    initialValue: false,
});
//# sourceMappingURL=ListItemField.js.map