"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const React = __importStar(require("react"));
const react_1 = require("react");
const Select_1 = require("@patternfly/react-core/dist/js/components/Select");
const wrapField_1 = __importDefault(require("./wrapField"));
function isSelectOptionObject(toBeDetermined) {
    return typeof toBeDetermined === "object" && !Array.isArray(toBeDetermined) && toBeDetermined !== null;
}
function SelectInputsField(props) {
    const [expanded, setExpanded] = (0, react_1.useState)(false);
    const [selected, setSelected] = (0, react_1.useState)(() => {
        if (props.value === undefined) {
            return [];
        }
        if (props.value === null) {
            return "null";
        }
        if (Array.isArray(props.value)) {
            return [...props.value];
        }
        return props.value;
    });
    const parseSelection = (0, react_1.useCallback)((selection, fieldType) => {
        if (selection === null) {
            return `${selection}`;
        }
        const parsedSelection = isSelectOptionObject(selection) ? selection.toString() : selection;
        if (fieldType !== Array) {
            return parsedSelection !== "" ? `${parsedSelection}` : "";
        }
        if (Array.isArray(selected)) {
            if (selected.includes(`${parsedSelection}`)) {
                return selected.filter((s) => s !== `${parsedSelection}`);
            }
            return [`${parsedSelection}`, ...selected];
        }
        return [];
    }, [selected]);
    const handleSelect = (0, react_1.useCallback)((event, selection) => {
        if (selection === props.placeholder) {
            props.onChange(undefined);
            setSelected([]);
        }
        else {
            if (selection === "null") {
                props.onChange(null);
                setSelected("null");
            }
            else {
                const selectedItems = parseSelection(selection, props.fieldType);
                const onChanged = selection === null
                    ? null
                    : typeof selection === "number"
                        ? Array.isArray(selectedItems)
                            ? selectedItems.map((item) => JSON.parse(item))
                            : JSON.parse(selectedItems)
                        : selectedItems;
                props.onChange(onChanged);
                setSelected(selectedItems);
            }
        }
        setExpanded(false);
    }, [parseSelection, props]);
    const selectOptions = (0, react_1.useMemo)(() => {
        var _a;
        const options = [];
        if (props.placeholder) {
            options.push(React.createElement(Select_1.SelectOption, { key: `placeholder ${props.allowedValues.length}`, isPlaceholder: true, value: props.placeholder }));
        }
        (_a = props.allowedValues) === null || _a === void 0 ? void 0 : _a.forEach((value) => options.push(React.createElement(Select_1.SelectOption, { key: value, value: value }, props.transform ? props.transform(value) : `${value}`)));
        return options;
    }, [props]);
    return (0, wrapField_1.default)(props, React.createElement("div", { "data-testid": "select-inputs-field", id: props.id },
        React.createElement(Select_1.Select, { isDisabled: props.disabled, id: props.id, variant: props.fieldType === Array ? Select_1.SelectVariant.typeaheadMulti : Select_1.SelectVariant.single, name: props.name, placeholderText: props.placeholder, isOpen: expanded, selections: selected, onToggle: (isExpanded) => setExpanded(isExpanded), onSelect: handleSelect, menuAppendTo: props.menuAppendTo, direction: props.direction }, selectOptions)));
}
exports.default = SelectInputsField;
//# sourceMappingURL=SelectInputsField.js.map