"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderSingleEditorApp = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var ReactDOM = require("react-dom");
var utils_1 = require("../../utils");
var SingleEditorApp_1 = require("./SingleEditorApp");
var Main_1 = require("../common/Main");
var constants_1 = require("../../constants");
var GlobalContext_1 = require("../common/GlobalContext");
function renderSingleEditorApp(args) {
    return __awaiter(this, void 0, void 0, function () {
        var openFileExtension, openFilePath;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, (0, utils_1.waitForElementToBeReady)(".cm-content")];
                case 1:
                    _a.sent();
                    if (!args.dependencies.singleEdit.githubTextEditorToReplaceElement()) {
                        args.logger.log("Doesn't look like the GitHub page is ready yet.");
                        return [2];
                    }
                    openFileExtension = (0, utils_1.extractOpenFileExtension)(window.location.href);
                    openFilePath = (0, utils_1.extractOpenFilePath)(window.location.href);
                    if (!openFileExtension) {
                        args.logger.log("Unable to determine file extension from URL.");
                        return [2];
                    }
                    if (!args.editorEnvelopeLocator.hasMappingFor(openFilePath)) {
                        args.logger.log("No enhanced editor available for \"".concat(openFilePath, "\" format."));
                        return [2];
                    }
                    cleanup(args.id, args.dependencies);
                    ReactDOM.render((0, jsx_runtime_1.jsx)(Main_1.Main, __assign({ id: args.id, editorEnvelopeLocator: args.editorEnvelopeLocator, dependencies: args.dependencies, logger: args.logger, githubAuthTokenCookieName: args.githubAuthTokenCookieName, extensionIconUrl: args.extensionIconUrl, resourceContentServiceFactory: args.resourceContentServiceFactory, externalEditorManager: args.externalEditorManager, customChannelApiImpl: args.customChannelApiImpl, stateControl: args.stateControl }, { children: (0, jsx_runtime_1.jsx)(SingleEditorEditApp, { openFileExtension: openFileExtension, fileInfo: args.fileInfo }) })), (0, utils_1.createAndGetMainContainer)(args.id, args.dependencies.all.body()), function () { return args.logger.log("Mounted."); });
                    return [2];
            }
        });
    });
}
exports.renderSingleEditorApp = renderSingleEditorApp;
function SingleEditorEditApp(props) {
    var globals = (0, GlobalContext_1.useGlobals)();
    (0, react_1.useEffect)(function () {
        (0, utils_1.runScriptOnPage)(chrome.runtime.getURL("scripts/set_content.js"));
    }, [props.fileInfo]);
    var getFileName = (0, react_1.useCallback)(function () {
        return globals.dependencies.all.edit__githubFileNameInput().value;
    }, [globals.dependencies]);
    var getFileContents = (0, react_1.useCallback)(function () {
        var _a, _b;
        return Promise.resolve((_b = (_a = globals.dependencies.all.edit__githubTextAreaWithFileContents()) === null || _a === void 0 ? void 0 : _a.textContent) !== null && _b !== void 0 ? _b : "");
    }, [globals.dependencies]);
    return ((0, jsx_runtime_1.jsx)(SingleEditorApp_1.SingleEditorApp, { readonly: false, openFileExtension: props.openFileExtension, getFileName: getFileName, getFileContents: getFileContents, iframeContainer: iframeContainer(globals.id, globals.dependencies), toolbarContainer: toolbarContainer(globals.id, globals.dependencies), githubTextEditorToReplace: globals.dependencies.singleEdit.githubTextEditorToReplaceElement(), fileInfo: props.fileInfo }));
}
function cleanup(id, dependencies) {
    (0, utils_1.removeAllChildren)(iframeContainer(id, dependencies));
    (0, utils_1.removeAllChildren)(toolbarContainer(id, dependencies));
    (0, utils_1.removeAllChildren)((0, utils_1.iframeFullscreenContainer)(id, dependencies.all.body()));
    (0, utils_1.removeAllChildren)((0, utils_1.createAndGetMainContainer)(id, dependencies.all.body()));
}
function toolbarContainer(id, dependencies) {
    var _a;
    var element = function () { return document.querySelector(".".concat(constants_1.KOGITO_TOOLBAR_CONTAINER_CLASS, ".").concat(id)); };
    if (element) {
        (_a = element()) === null || _a === void 0 ? void 0 : _a.remove();
    }
    dependencies.singleEdit
        .toolbarContainerTarget()
        .insertAdjacentHTML("beforebegin", "<div style=\"width:100%; padding-bottom: 10px;\" class=\"".concat(constants_1.KOGITO_TOOLBAR_CONTAINER_CLASS, " ").concat(id, " edit d-flex flex-column flex-items-start flex-md-row\"></div>"));
    return element();
}
function iframeContainer(id, dependencies) {
    var _a;
    var element = function () { return document.querySelector(".".concat(constants_1.KOGITO_IFRAME_CONTAINER_CLASS, ".").concat(id)); };
    if (element) {
        (_a = element()) === null || _a === void 0 ? void 0 : _a.remove();
    }
    dependencies.singleEdit
        .iframeContainerTarget()
        .insertAdjacentHTML("afterend", "<div class=\"".concat(constants_1.KOGITO_IFRAME_CONTAINER_CLASS, " ").concat(id, " edit\"></div>"));
    return element();
}
//# sourceMappingURL=singleEditorEdit.js.map