/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.optaplanner.constraint.streams.drools;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

import org.drools.model.Global;
import org.kie.api.KieBase;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;

public final class KieBaseDescriptor<Solution_> implements Supplier<KieBase> {

    private final Map<DroolsConstraint<Solution_>, Global<WeightedScoreImpacter>> constraintToGlobalMap;
    private final KieBase kieBase;

    KieBaseDescriptor(Map<DroolsConstraint<Solution_>, Global<WeightedScoreImpacter>> constraintToGlobalMap,
            KieBase kieBase) {
        this.constraintToGlobalMap = Objects.requireNonNull(constraintToGlobalMap);
        this.kieBase = Objects.requireNonNull(kieBase);
    }

    public Map<DroolsConstraint<Solution_>, Global<WeightedScoreImpacter>> getConstraintToGlobalMap() {
        return constraintToGlobalMap;
    }

    @Override
    public KieBase get() {
        return kieBase;
    }

}
