/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.impl;

import org.apache.ignite3.internal.metastorage.command.response.ChecksumInfo;
import org.apache.ignite3.internal.metastorage.impl.MetastorageDivergedException;

public class MetastorageDivergencyValidator {
    public void validate(long revision, long localChecksum, ChecksumInfo leaderChecksumInfo) {
        if (leaderChecksumInfo.minRevision() == 0L || leaderChecksumInfo.maxRevision() == 0L) {
            throw new MetastorageDivergedException("Metastorage on leader does not have any checksums, this should not happen");
        }
        if (revision >= leaderChecksumInfo.minRevision() && revision <= leaderChecksumInfo.maxRevision()) {
            if (localChecksum != leaderChecksumInfo.checksum()) {
                throw new MetastorageDivergedException(String.format("Metastorage has diverged [revision=%d, localChecksum=%d, leaderChecksum=%d", revision, localChecksum, leaderChecksumInfo.checksum()));
            }
        } else {
            if (revision > leaderChecksumInfo.maxRevision()) {
                throw new MetastorageDivergedException(String.format("Node is ahead of the leader, this should not happen; probably means divergence [localRevision=%d, leaderRevision=%d]", revision, leaderChecksumInfo.maxRevision()));
            }
            assert (revision < leaderChecksumInfo.minRevision());
            throw new MetastorageDivergedException(String.format("Node revision is already removed due to compaction on the leader [localRevision=%d, minLeaderRevision=%d]", revision, leaderChecksumInfo.minRevision()));
        }
    }
}

