/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.config.loader;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;

public class BeanWrapperSpy
implements BeanWrapper {
    private final MultiValuedMap<Object, Pair<PropertyDescriptor, BeanDefinition>> propertyTracker;
    private final BeanWrapper base;
    private final BeanDefinition mdb;

    public BeanWrapperSpy(MultiValuedMap<Object, Pair<PropertyDescriptor, BeanDefinition>> propertyTracker, BeanWrapper base, RootBeanDefinition mbd) {
        this.propertyTracker = propertyTracker;
        this.base = base;
        this.mdb = mbd;
    }

    private void registerProperty(PropertyValue pv) {
        Object instance = this.getWrappedInstance();
        PropertyDescriptor descriptor = this.getPropertyDescriptor(pv.getName());
        this.propertyTracker.put(instance, (Object)Pair.of((Object)descriptor, (Object)this.mdb));
    }

    public int getAutoGrowCollectionLimit() {
        return this.base.getAutoGrowCollectionLimit();
    }

    public void setAutoGrowCollectionLimit(int autoGrowCollectionLimit) {
        this.base.setAutoGrowCollectionLimit(autoGrowCollectionLimit);
    }

    public Object getWrappedInstance() {
        return this.base.getWrappedInstance();
    }

    public Class<?> getWrappedClass() {
        return this.base.getWrappedClass();
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.base.getPropertyDescriptors();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws InvalidPropertyException {
        return this.base.getPropertyDescriptor(propertyName);
    }

    @Nullable
    public ConversionService getConversionService() {
        return this.base.getConversionService();
    }

    public void setConversionService(ConversionService conversionService) {
        this.base.setConversionService(conversionService);
    }

    public boolean isExtractOldValueForEditor() {
        return this.base.isExtractOldValueForEditor();
    }

    public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
        this.base.setExtractOldValueForEditor(extractOldValueForEditor);
    }

    public boolean isAutoGrowNestedPaths() {
        return this.base.isAutoGrowNestedPaths();
    }

    public void setAutoGrowNestedPaths(boolean autoGrowNestedPaths) {
        this.base.setAutoGrowNestedPaths(autoGrowNestedPaths);
    }

    public boolean isReadableProperty(String propertyName) {
        return this.base.isReadableProperty(propertyName);
    }

    public boolean isWritableProperty(String propertyName) {
        return this.base.isWritableProperty(propertyName);
    }

    @Nullable
    public Class<?> getPropertyType(String propertyName) throws BeansException {
        return this.base.getPropertyType(propertyName);
    }

    @Nullable
    public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
        return this.base.getPropertyTypeDescriptor(propertyName);
    }

    @Nullable
    public Object getPropertyValue(String propertyName) throws BeansException {
        return this.base.getPropertyValue(propertyName);
    }

    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        this.base.setPropertyValue(propertyName, value);
    }

    public void setPropertyValue(PropertyValue pv) throws BeansException {
        this.base.setPropertyValue(pv);
        this.registerProperty(pv);
    }

    public void setPropertyValues(Map<?, ?> map) throws BeansException {
        this.base.setPropertyValues(map);
    }

    public void setPropertyValues(PropertyValues pvs) throws BeansException {
        this.base.setPropertyValues(pvs);
        for (PropertyValue pv : pvs) {
            this.registerProperty(pv);
        }
    }

    public void setPropertyValues(PropertyValues pvs, boolean ignoreUnknown) throws BeansException {
        this.base.setPropertyValues(pvs, ignoreUnknown);
    }

    public void setPropertyValues(PropertyValues pvs, boolean ignoreUnknown, boolean ignoreInvalid) throws BeansException {
        this.base.setPropertyValues(pvs, ignoreUnknown, ignoreInvalid);
    }

    public void registerCustomEditor(Class<?> requiredType, PropertyEditor propertyEditor) {
        this.base.registerCustomEditor(requiredType, propertyEditor);
    }

    public void registerCustomEditor(Class<?> requiredType, String propertyPath, PropertyEditor propertyEditor) {
        this.base.registerCustomEditor(requiredType, propertyPath, propertyEditor);
    }

    @Nullable
    public PropertyEditor findCustomEditor(Class<?> requiredType, String propertyPath) {
        return this.base.findCustomEditor(requiredType, propertyPath);
    }

    @Nullable
    public <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
        return (T)this.base.convertIfNecessary(value, requiredType);
    }

    @Nullable
    public <T> T convertIfNecessary(Object value, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        Object[] newValue = value;
        if (requiredType.isArray() && requiredType.getComponentType().isPrimitive()) {
            if (value instanceof Collection) {
                newValue = ((Collection)value).stream().filter(Objects::nonNull).toArray();
            } else if (value.getClass().isArray() && !value.getClass().isPrimitive()) {
                newValue = Arrays.stream(value).filter(Objects::nonNull).toArray();
            }
        }
        return (T)this.base.convertIfNecessary((Object)newValue, requiredType, methodParam);
    }

    @Nullable
    public <T> T convertIfNecessary(Object value, Class<T> requiredType, Field field) throws TypeMismatchException {
        return (T)this.base.convertIfNecessary(value, requiredType, field);
    }

    @Nullable
    public <T> T convertIfNecessary(Object value, Class<T> requiredType, TypeDescriptor typeDescriptor) throws TypeMismatchException {
        return (T)this.base.convertIfNecessary(value, requiredType, typeDescriptor);
    }
}

