/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.catalog.definitions;

import java.util.Objects;

public class ZoneDefinition {
    private final String zoneName;
    private final boolean ifNotExists;
    private final Integer partitions;
    private final Integer replicas;
    private final Integer quorumSize;
    private final String distributionAlgorithm;
    private final Integer dataNodesAutoAdjust;
    private final Integer dataNodesAutoAdjustScaleUp;
    private final Integer dataNodesAutoAdjustScaleDown;
    private final String filter;
    private final String storageProfiles;
    private final String consistencyMode;

    private ZoneDefinition(String zoneName, boolean ifNotExists, Integer partitions, Integer replicas, Integer quorumSize, String distributionAlgorithm, Integer dataNodesAutoAdjust, Integer dataNodesAutoAdjustScaleUp, Integer dataNodesAutoAdjustScaleDown, String filter, String storageProfiles, String consistencyMode) {
        this.zoneName = zoneName;
        this.ifNotExists = ifNotExists;
        this.partitions = partitions;
        this.replicas = replicas;
        this.quorumSize = quorumSize;
        this.distributionAlgorithm = distributionAlgorithm;
        this.dataNodesAutoAdjust = dataNodesAutoAdjust;
        this.dataNodesAutoAdjustScaleUp = dataNodesAutoAdjustScaleUp;
        this.dataNodesAutoAdjustScaleDown = dataNodesAutoAdjustScaleDown;
        this.filter = filter;
        this.storageProfiles = storageProfiles;
        this.consistencyMode = consistencyMode;
    }

    public static Builder builder(String zoneName) {
        return new Builder().zoneName(zoneName);
    }

    public String zoneName() {
        return this.zoneName;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public Integer partitions() {
        return this.partitions;
    }

    public Integer replicas() {
        return this.replicas;
    }

    public Integer quorumSize() {
        return this.quorumSize;
    }

    public String distributionAlgorithm() {
        return this.distributionAlgorithm;
    }

    @Deprecated
    public Integer dataNodesAutoAdjust() {
        return this.dataNodesAutoAdjust;
    }

    public Integer dataNodesAutoAdjustScaleUp() {
        return this.dataNodesAutoAdjustScaleUp;
    }

    public Integer dataNodesAutoAdjustScaleDown() {
        return this.dataNodesAutoAdjustScaleDown;
    }

    public String filter() {
        return this.filter;
    }

    public String storageProfiles() {
        return this.storageProfiles;
    }

    public String consistencyMode() {
        return this.consistencyMode;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "ZoneDefinition{zoneName='" + this.zoneName + "', ifNotExists=" + this.ifNotExists + ", partitions=" + this.partitions + ", replicas=" + this.replicas + ", quorumSize=" + this.quorumSize + ", distributionAlgorithm='" + this.distributionAlgorithm + "', dataNodesAutoAdjust=" + this.dataNodesAutoAdjust + ", dataNodesAutoAdjustScaleUp=" + this.dataNodesAutoAdjustScaleUp + ", dataNodesAutoAdjustScaleDown=" + this.dataNodesAutoAdjustScaleDown + ", filter='" + this.filter + "', storageProfiles='" + this.storageProfiles + "', consistencyMode='" + this.consistencyMode + "'}";
    }

    public static class Builder {
        private String zoneName;
        private boolean ifNotExists;
        private Integer partitions;
        private Integer replicas;
        private Integer quorumSize;
        private String distributionAlgorithm;
        private Integer dataNodesAutoAdjust;
        private Integer dataNodesAutoAdjustScaleUp;
        private Integer dataNodesAutoAdjustScaleDown;
        private String filter;
        private String storageProfiles;
        private String consistencyMode;

        private Builder() {
        }

        private Builder(ZoneDefinition definition) {
            this.zoneName = definition.zoneName;
            this.ifNotExists = definition.ifNotExists;
            this.partitions = definition.partitions;
            this.replicas = definition.replicas;
            this.quorumSize = definition.quorumSize;
            this.distributionAlgorithm = definition.distributionAlgorithm;
            this.dataNodesAutoAdjust = definition.dataNodesAutoAdjust;
            this.dataNodesAutoAdjustScaleUp = definition.dataNodesAutoAdjustScaleUp;
            this.dataNodesAutoAdjustScaleDown = definition.dataNodesAutoAdjustScaleDown;
            this.filter = definition.filter;
            this.storageProfiles = definition.storageProfiles;
            this.consistencyMode = definition.consistencyMode;
        }

        Builder zoneName(String zoneName) {
            Objects.requireNonNull(zoneName, "Zone name must not be null.");
            if (zoneName.isBlank()) {
                throw new IllegalArgumentException("Zone name must not be blank.");
            }
            this.zoneName = zoneName;
            return this;
        }

        public Builder ifNotExists() {
            this.ifNotExists = true;
            return this;
        }

        public Builder partitions(Integer partitions) {
            Objects.requireNonNull(partitions, "Number of partitions must not be null.");
            this.partitions = partitions;
            return this;
        }

        public Builder replicas(Integer replicas) {
            Objects.requireNonNull(replicas, "Number of replicas must not be null.");
            this.replicas = replicas;
            return this;
        }

        public Builder quorumSize(Integer quorumSize) {
            Objects.requireNonNull(quorumSize, "Quorum size must not be null.");
            this.quorumSize = quorumSize;
            return this;
        }

        public Builder distributionAlgorithm(String distributionAlgorithm) {
            Objects.requireNonNull(distributionAlgorithm, "Partition distribution algorithm must not be null.");
            if (distributionAlgorithm.isBlank()) {
                throw new IllegalArgumentException("Partition distribution algorithm must not be blank.");
            }
            this.distributionAlgorithm = distributionAlgorithm;
            return this;
        }

        @Deprecated
        public Builder dataNodesAutoAdjust(Integer adjust) {
            Objects.requireNonNull(adjust, "Timeout between node added or node left topology event itself and data nodes switch must not be null.");
            this.dataNodesAutoAdjust = adjust;
            return this;
        }

        public Builder dataNodesAutoAdjustScaleUp(Integer adjust) {
            Objects.requireNonNull(adjust, "Timeout between node added topology event itself and data nodes switch must not be null.");
            this.dataNodesAutoAdjustScaleUp = adjust;
            return this;
        }

        public Builder dataNodesAutoAdjustScaleDown(Integer adjust) {
            Objects.requireNonNull(adjust, "Timeout between node left topology event itself and data nodes switch must not be null.");
            this.dataNodesAutoAdjustScaleDown = adjust;
            return this;
        }

        public Builder filter(String filter) {
            Objects.requireNonNull(filter, "Filter must not be null.");
            if (filter.isBlank()) {
                throw new IllegalArgumentException("Filter must not be blank.");
            }
            this.filter = filter;
            return this;
        }

        public Builder storageProfiles(String storageProfiles) {
            Objects.requireNonNull(storageProfiles, "Storage profiles must not be null.");
            this.storageProfiles = storageProfiles;
            return this;
        }

        public Builder consistencyMode(String consistencyMode) {
            Objects.requireNonNull(consistencyMode, "Consistency mode must not be null.");
            this.consistencyMode = consistencyMode;
            return this;
        }

        public ZoneDefinition build() {
            return new ZoneDefinition(this.zoneName, this.ifNotExists, this.partitions, this.replicas, this.quorumSize, this.distributionAlgorithm, this.dataNodesAutoAdjust, this.dataNodesAutoAdjustScaleUp, this.dataNodesAutoAdjustScaleDown, this.filter, this.storageProfiles, this.consistencyMode);
        }
    }
}

