/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.exception.handler;

import org.apache.ignite.internal.cli.config.exception.ConfigStoringException;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite.internal.cli.core.style.element.UiElement;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;

public class ConfigStoringExceptionHandler
implements ExceptionHandler<ConfigStoringException> {
    private static final IgniteLogger log = Loggers.forClass(ConfigStoringExceptionHandler.class);

    @Override
    public int handle(ExceptionWriter err, ConfigStoringException e) {
        ErrorUiComponent errorComponent = ErrorUiComponent.builder().header("Could not save CLI config", new UiElement[0]).details(e.getMessage(), new UiElement[0]).build();
        log.error(errorComponent.header(), (Throwable)e);
        err.write(errorComponent.render());
        return 1;
    }

    @Override
    public Class<ConfigStoringException> applicableException() {
        return ConfigStoringException.class;
    }
}

