/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.recovery;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.api.recovery.DisasterRecoveryApi;
import org.apache.ignite.internal.rest.api.recovery.GlobalPartitionStateResponse;
import org.apache.ignite.internal.rest.api.recovery.GlobalPartitionStatesResponse;
import org.apache.ignite.internal.rest.api.recovery.LocalPartitionStateResponse;
import org.apache.ignite.internal.rest.api.recovery.LocalPartitionStatesResponse;
import org.apache.ignite.internal.rest.api.recovery.ResetPartitionsRequest;
import org.apache.ignite.internal.rest.api.recovery.RestartPartitionsRequest;
import org.apache.ignite.internal.rest.exception.handler.IgniteInternalExceptionHandler;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.apache.ignite.internal.table.distributed.disaster.GlobalPartitionState;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionState;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionStateByNode;
import org.apache.ignite.table.QualifiedName;

@Controller(value="/management/v1/recovery/")
@Requires(classes={IgniteInternalExceptionHandler.class})
public class DisasterRecoveryController
implements DisasterRecoveryApi,
ResourceHolder {
    private DisasterRecoveryManager disasterRecoveryManager;

    public DisasterRecoveryController(DisasterRecoveryManager disasterRecoveryManager) {
        this.disasterRecoveryManager = disasterRecoveryManager;
    }

    public CompletableFuture<LocalPartitionStatesResponse> getLocalPartitionStates(Optional<Set<String>> zoneNames, Optional<Set<String>> nodeNames, Optional<Set<Integer>> partitionIds) {
        return this.disasterRecoveryManager.localPartitionStates(zoneNames.orElse(Set.of()), nodeNames.orElse(Set.of()), partitionIds.orElse(Set.of())).thenApply(DisasterRecoveryController::convertLocalStates);
    }

    public CompletableFuture<GlobalPartitionStatesResponse> getGlobalPartitionStates(Optional<Set<String>> zoneNames, Optional<Set<Integer>> partitionIds) {
        return this.disasterRecoveryManager.globalPartitionStates(zoneNames.orElse(Set.of()), partitionIds.orElse(Set.of())).thenApply(DisasterRecoveryController::convertGlobalStates);
    }

    public CompletableFuture<Void> resetPartitions(@Body ResetPartitionsRequest command) {
        QualifiedName tableName = QualifiedName.parse((String)command.tableName());
        return this.disasterRecoveryManager.resetPartitions(command.zoneName(), tableName.schemaName(), tableName.objectName(), command.partitionIds());
    }

    public CompletableFuture<Void> restartPartitions(@Body RestartPartitionsRequest command) {
        QualifiedName tableName = QualifiedName.parse((String)command.tableName());
        return this.disasterRecoveryManager.restartPartitions(command.nodeNames(), command.zoneName(), tableName.schemaName(), tableName.objectName(), command.partitionIds());
    }

    private static LocalPartitionStatesResponse convertLocalStates(Map<TablePartitionId, LocalPartitionStateByNode> localStates) {
        ArrayList<LocalPartitionStateResponse> states = new ArrayList<LocalPartitionStateResponse>();
        for (LocalPartitionStateByNode map : localStates.values()) {
            for (Map.Entry entry : map.entrySet()) {
                String nodeName = (String)entry.getKey();
                LocalPartitionState state = (LocalPartitionState)entry.getValue();
                states.add(new LocalPartitionStateResponse(nodeName, state.zoneName, state.schemaName, state.tableId, state.tableName, state.partitionId, state.state.name(), state.estimatedRows));
            }
        }
        states.sort(Comparator.comparing(LocalPartitionStateResponse::schemaName).thenComparing(LocalPartitionStateResponse::tableName).thenComparingInt(LocalPartitionStateResponse::partitionId).thenComparing(LocalPartitionStateResponse::nodeName));
        return new LocalPartitionStatesResponse(states);
    }

    private static GlobalPartitionStatesResponse convertGlobalStates(Map<TablePartitionId, GlobalPartitionState> globalStates) {
        ArrayList<GlobalPartitionStateResponse> states = new ArrayList<GlobalPartitionStateResponse>();
        for (GlobalPartitionState state : globalStates.values()) {
            states.add(new GlobalPartitionStateResponse(state.zoneName, state.schemaName, state.tableId, state.tableName, state.partitionId, state.state.name()));
        }
        states.sort(Comparator.comparing(GlobalPartitionStateResponse::schemaName).thenComparing(GlobalPartitionStateResponse::tableName).thenComparingInt(GlobalPartitionStateResponse::partitionId));
        return new GlobalPartitionStatesResponse(states);
    }

    public void cleanResources() {
        this.disasterRecoveryManager = null;
    }
}

