/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.catalog;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class ColumnType<T> {
    private static final Map<Class<?>, ColumnType<?>> TYPES = new LinkedHashMap();
    public static final ColumnType<Boolean> BOOLEAN = new ColumnType<Boolean>(Boolean.class, "boolean");
    public static final ColumnType<Byte> TINYINT = new ColumnType<Byte>(Byte.class, "tinyint");
    public static final ColumnType<Short> SMALLINT = new ColumnType<Short>(Short.class, "smallint");
    public static final ColumnType<Integer> INTEGER = new ColumnType<Integer>(Integer.class, "int");
    public static final ColumnType<Long> BIGINT = new ColumnType<Long>(Long.class, "bigint");
    public static final ColumnType<Byte> INT8 = TINYINT;
    public static final ColumnType<Short> INT16 = SMALLINT;
    public static final ColumnType<Integer> INT32 = INTEGER;
    public static final ColumnType<Long> INT64 = BIGINT;
    public static final ColumnType<Float> REAL = new ColumnType<Float>(Float.class, "real");
    public static final ColumnType<Float> FLOAT = REAL;
    public static final ColumnType<Double> DOUBLE = new ColumnType<Double>(Double.class, "double");
    public static final ColumnType<String> VARCHAR = new ColumnType<String>(String.class, "varchar");
    public static final ColumnType<byte[]> VARBINARY = new ColumnType<byte[]>(byte[].class, "varbinary");
    public static final ColumnType<LocalTime> TIME = new ColumnType<LocalTime>(LocalTime.class, "time");
    public static final ColumnType<LocalDateTime> TIMESTAMP = new ColumnType<LocalDateTime>(LocalDateTime.class, "timestamp");
    public static final ColumnType<LocalDate> DATE = new ColumnType<LocalDate>(LocalDate.class, "date");
    public static final ColumnType<BigDecimal> DECIMAL = new ColumnType<BigDecimal>(BigDecimal.class, "decimal");
    public static final ColumnType<UUID> UUID = new ColumnType<UUID>(UUID.class, "uuid");
    public static final ColumnType<Instant> TIMESTAMP_WITH_LOCAL_TIME_ZONE = new ColumnType<Instant>(Instant.class, "timestamp with local time zone");
    private final Class<T> type;
    private final String typeName;
    private Boolean nullable;
    private T defaultValue;
    private String defaultExpression;
    private Integer precision;
    private Integer scale;
    private Integer length;

    public static ColumnType<String> varchar(int length) {
        return VARCHAR.copy().length(length);
    }

    public static ColumnType<byte[]> varbinary(int length) {
        return VARBINARY.copy().length(length);
    }

    public static ColumnType<LocalTime> time(int precision) {
        return TIME.copy().precision(precision);
    }

    public static ColumnType<LocalDateTime> timestamp(int precision) {
        return TIMESTAMP.copy().precision(precision);
    }

    public static ColumnType<BigDecimal> decimal(int precision, int scale) {
        return DECIMAL.copy().precision(precision, scale);
    }

    private ColumnType(Class<T> type, String typeName) {
        this.type = type;
        this.typeName = typeName;
        TYPES.putIfAbsent(type, this);
    }

    private ColumnType(ColumnType<T> ref) {
        this.type = ref.type;
        this.typeName = ref.typeName;
        this.nullable = ref.nullable;
        this.defaultValue = ref.defaultValue;
        this.defaultExpression = ref.defaultExpression;
        this.precision = ref.precision;
        this.scale = ref.scale;
        this.length = ref.length;
    }

    public static ColumnType<?> of(Class<?> type, Integer length, Integer precision, Integer scale, Boolean nullable) {
        return ColumnType.of(type).length_(length).precision_(precision, scale).nullable_(nullable);
    }

    public static ColumnType<?> of(Class<?> type) {
        ColumnType<?> columnType = TYPES.get(type);
        if (columnType == null) {
            throw new UnsupportedOperationException("Class is not supported: " + type.getCanonicalName());
        }
        return columnType.copy();
    }

    public Class<T> type() {
        return this.type;
    }

    public String typeName() {
        return this.typeName;
    }

    public Boolean nullable() {
        return this.nullable;
    }

    public ColumnType<T> nullable(Boolean n) {
        return this.copy().nullable_(n);
    }

    public ColumnType<T> notNull() {
        return this.nullable(false);
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public ColumnType<T> defaultValue(T value) {
        return this.copy().defaultValue_(value);
    }

    public String defaultExpression() {
        return this.defaultExpression;
    }

    public ColumnType<T> defaultExpression(String expression) {
        return this.copy().defaultExpression_(expression);
    }

    public Integer precision() {
        return this.precision;
    }

    public ColumnType<T> precision(Integer precision) {
        return this.copy().precision_(precision);
    }

    public ColumnType<T> precision(Integer precision, Integer scale) {
        return this.copy().precision_(precision, scale);
    }

    public Integer scale() {
        return this.scale;
    }

    public Integer length() {
        return this.length;
    }

    public ColumnType<T> length(Integer length) {
        return this.copy().length_(length);
    }

    private ColumnType<T> copy() {
        return new ColumnType<T>(this);
    }

    private ColumnType<T> nullable_(Boolean n) {
        this.nullable = n;
        return this;
    }

    private ColumnType<T> defaultValue_(T value) {
        this.defaultValue = value;
        return this;
    }

    private ColumnType<T> defaultExpression_(String expression) {
        this.defaultExpression = expression;
        return this;
    }

    private ColumnType<T> precision_(Integer precision) {
        this.precision = precision;
        return this;
    }

    private ColumnType<T> precision_(Integer precision, Integer scale) {
        this.precision = precision;
        this.scale = scale;
        return this;
    }

    private ColumnType<T> length_(Integer length) {
        this.length = length;
        return this;
    }
}

